/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.style.java;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jst.jsp.ui.internal.style.java.JavaColorProvider;
import org.eclipse.jst.jsp.ui.internal.style.java.JavaWordDetector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class JavaCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while", "strictfp"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};

    public JavaCodeScanner() {
        Color background = null;
        JavaColorProvider.getInstance().loadJavaColors();
        Token keyword = new Token((Object)new TextAttribute(EditorUtility.getColor((RGB)JavaColorProvider.KEYWORD), background, JavaColorProvider.KEYWORD_BOLD));
        Token type = new Token((Object)new TextAttribute(EditorUtility.getColor((RGB)JavaColorProvider.TYPE), background, JavaColorProvider.TYPE_BOLD));
        Token string = new Token((Object)new TextAttribute(EditorUtility.getColor((RGB)JavaColorProvider.STRING), background, JavaColorProvider.STRING_BOLD));
        Token comment = new Token((Object)new TextAttribute(EditorUtility.getColor((RGB)JavaColorProvider.SINGLE_LINE_COMMENT), background, JavaColorProvider.SINGLE_LINE_COMMENT_BOLD));
        Token other = new Token((Object)new TextAttribute(EditorUtility.getColor((RGB)JavaColorProvider.DEFAULT), background, JavaColorProvider.DEFAULT_BOLD));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("/*", "*/", (IToken)comment));
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

