/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerUtil {
    private ServerUtil() {
    }

    public static IModule[] getModules(IProject project) {
        if (project == null) {
            return null;
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules();
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                if (modules[i] != null && project.equals((Object)modules[i].getProject())) {
                    list.add(modules[i]);
                }
                ++i;
            }
        }
        IModule[] modules2 = new IModule[list.size()];
        list.toArray(modules2);
        return modules2;
    }

    public static IModule getModule(String moduleId) {
        if (moduleId == null) {
            throw new IllegalArgumentException();
        }
        int index = moduleId.indexOf(":");
        if (index <= 0) {
            return null;
        }
        String factoryId = moduleId.substring(0, index);
        ModuleFactory moduleFactory = ServerPlugin.findModuleFactory(factoryId);
        if (moduleFactory == null) {
            return null;
        }
        String moduleSubId = moduleId.substring(index + 1);
        IModule module = moduleFactory.getModule(moduleSubId);
        if (module != null) {
            return module;
        }
        return null;
    }

    public static IModule[] getModules(IModuleType[] moduleTypes) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            int size = factories.length;
            int i = 0;
            while (i < size) {
                IModule[] modules;
                if (ServerUtil.isSupportedModule(factories[i].getModuleTypes(), moduleTypes) && (modules = factories[i].getModules()) != null) {
                    int size2 = modules.length;
                    int j = 0;
                    while (j < size2) {
                        list.add(modules[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static IModule[] getModules(String type) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            int size = factories.length;
            int i = 0;
            while (i < size) {
                IModule[] modules;
                if (ServerUtil.isSupportedModule(factories[i].getModuleTypes(), type, null) && (modules = factories[i].getModules()) != null) {
                    int size2 = modules.length;
                    int j = 0;
                    while (j < size2) {
                        list.add(modules[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static boolean isSupportedModule(IModuleType[] moduleTypes, String typeId, String versionId) {
        if (moduleTypes != null) {
            int size = moduleTypes.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(moduleTypes[i], typeId, versionId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isSupportedModule(IModuleType[] moduleTypes, IModuleType[] mt) {
        if (mt != null) {
            int size = mt.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(moduleTypes, mt[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isSupportedModule(IModuleType[] moduleTypes, IModuleType mt) {
        if (moduleTypes != null) {
            int size = moduleTypes.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(moduleTypes[i], mt)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isSupportedModule(IModuleType moduleType, String type, String version) {
        String version2;
        String type2 = moduleType.getId();
        return ServerUtil.matches(type, type2) && ServerUtil.matches(version, version2 = moduleType.getVersion());
    }

    public static boolean isSupportedModule(IModuleType moduleType, IModuleType mt) {
        if (moduleType == null || mt == null) {
            throw new IllegalArgumentException();
        }
        String type2 = moduleType.getId();
        if (ServerUtil.matches(mt.getId(), type2)) {
            String version2 = moduleType.getVersion();
            if (ServerUtil.matches(mt.getVersion(), version2)) {
                return true;
            }
        }
        return false;
    }

    private static boolean matches(String a, String b) {
        return a == null || b == null || "*".equals(a) || "*".equals(b) || a.startsWith(b) || b.startsWith(a) || a.endsWith(".*") && b.startsWith(a.substring(0, a.length() - 1)) || b.endsWith(".*") && a.startsWith(b.substring(0, b.length() - 1));
    }

    private static IModule[] getModules() {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            int size = factories.length;
            int i = 0;
            while (i < size) {
                IModule[] modules = factories[i].getModules();
                if (modules != null) {
                    int size2 = modules.length;
                    int j = 0;
                    while (j < size2) {
                        if (!list.contains(modules[j])) {
                            list.add(modules[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static void modifyModules(IServerWorkingCopy server, IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        if (server == null) {
            throw new IllegalArgumentException();
        }
        if (add == null) {
            add = new IModule[]{};
        }
        if (remove == null) {
            remove = new IModule[]{};
        }
        int size = add.length;
        ArrayList<IModule> addParentModules = new ArrayList<IModule>();
        int i = 0;
        while (i < size) {
            boolean found = false;
            try {
                IModule[] parents = server.getRootModules(add[i], monitor);
                if (parents != null) {
                    found = true;
                    if (parents.length > 0) {
                        IModule parent = parents[0];
                        found = true;
                        if (!addParentModules.contains(parent)) {
                            addParentModules.add(parent);
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Could not find parent module", e);
            }
            if (!found) {
                addParentModules.add(add[i]);
            }
            ++i;
        }
        size = remove.length;
        ArrayList<IModule> removeParentModules = new ArrayList<IModule>();
        int i2 = 0;
        while (i2 < size) {
            boolean found = false;
            try {
                IModule[] parents = server.getRootModules(remove[i2], monitor);
                if (parents != null) {
                    found = true;
                    if (parents.length > 0) {
                        IModule parent = parents[0];
                        found = true;
                        if (!removeParentModules.contains(parent)) {
                            removeParentModules.add(parent);
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Could not find parent module 2", e);
            }
            if (!found) {
                removeParentModules.add(remove[i2]);
            }
            ++i2;
        }
        IModule[] add2 = new IModule[addParentModules.size()];
        addParentModules.toArray(add2);
        IModule[] remove2 = new IModule[removeParentModules.size()];
        removeParentModules.toArray(remove2);
        server.modifyModules(add2, remove2, monitor);
    }

    public static void setRuntimeDefaultName(IRuntimeWorkingCopy runtime) {
        String typeName = runtime.getRuntimeType().getName();
        String name = NLS.bind((String)Messages.defaultRuntimeName, (Object)typeName);
        int i = 2;
        while (ServerUtil.isNameInUse(name)) {
            name = NLS.bind((String)Messages.defaultRuntimeName2, (Object[])new String[]{typeName, String.valueOf(i)});
            ++i;
        }
        runtime.setName(name);
    }

    public static void setServerDefaultName(IServerWorkingCopy server) {
        if (server == null) {
            throw new IllegalArgumentException();
        }
        String typeName = server.getServerType().getName();
        String host = server.getHost();
        String name = NLS.bind((String)Messages.defaultServerName, (Object[])new String[]{typeName, host});
        int i = 2;
        while (ServerUtil.isNameInUse(name)) {
            name = NLS.bind((String)Messages.defaultServerName2, (Object[])new String[]{typeName, host, String.valueOf(i)});
            ++i;
        }
        server.setName(name);
    }

    private static boolean isValidFilename(String name) {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (status != null && !status.isOK()) {
            return false;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 2);
        return status == null || status.isOK();
    }

    private static String getValidFileName(String name) {
        if (ServerUtil.isValidFilename(name)) {
            return name;
        }
        String[] s = new String[]{".", "\\", "/", "?", ":", "*", "\"", "|", "<", ">"};
        int ind = 0;
        while (ind < s.length) {
            int index = name.indexOf(s[ind]);
            while (index >= 0) {
                name = String.valueOf(name.substring(0, index)) + name.substring(index + 1);
                index = name.indexOf(s[ind]);
            }
            ++ind;
        }
        return name;
    }

    public static IFile getUnusedServerFile(IProject project, IServerType type) {
        if (project == null || type == null) {
            throw new IllegalArgumentException();
        }
        String typeName = ServerUtil.getValidFileName(type.getName());
        String name = String.valueOf(NLS.bind((String)Messages.defaultServerName3, (Object)typeName)) + "." + "server";
        int i = 2;
        while (ServerUtil.isFileNameInUse(project, name)) {
            name = String.valueOf(NLS.bind((String)Messages.defaultServerName4, (Object[])new String[]{typeName, String.valueOf(i)})) + "." + "server";
            ++i;
        }
        return project.getFile(name);
    }

    private static boolean isNameInUse(String name) {
        if (name == null) {
            return true;
        }
        ArrayList list = new ArrayList();
        ServerUtil.addAll(list, ServerCore.getRuntimes());
        ServerUtil.addAll(list, ServerCore.getServers());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof IServerAttributes && name.equalsIgnoreCase(((IServerAttributes)obj).getName())) {
                return true;
            }
            if (!(obj instanceof IRuntime) || !name.equalsIgnoreCase(((IRuntime)obj).getName())) continue;
            return true;
        }
        return false;
    }

    private static void addAll(List list, Object[] obj) {
        if (obj == null) {
            return;
        }
        int size = obj.length;
        int i = 0;
        while (i < size) {
            list.add(obj[i]);
            ++i;
        }
    }

    private static boolean isFileNameInUse(IProject project, String name) {
        if (name == null || project == null) {
            return false;
        }
        if (project.getFile(name).exists()) {
            return true;
        }
        return project.getFolder(name).exists();
    }

    public static IRuntime[] getRuntimes(String type, String version) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntimeType runtimeType = runtimes[i].getRuntimeType();
                if (runtimeType != null && ServerUtil.isSupportedModule(runtimeType.getModuleTypes(), type, version)) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        IRuntime[] runtimes2 = new IRuntime[list.size()];
        list.toArray(runtimes2);
        return runtimes2;
    }

    public static IRuntimeType[] getRuntimeTypes(String type, String version) {
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(runtimeTypes[i].getModuleTypes(), type, version)) {
                    list.add(runtimeTypes[i]);
                }
                ++i;
            }
        }
        IRuntimeType[] rt = new IRuntimeType[list.size()];
        list.toArray(rt);
        return rt;
    }

    public static IRuntimeType[] getRuntimeTypes(String type, String version, String runtimeTypeId) {
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(runtimeTypes[i].getModuleTypes(), type, version) && (runtimeTypeId == null || runtimeTypes[i].getId().startsWith(runtimeTypeId))) {
                    list.add(runtimeTypes[i]);
                }
                ++i;
            }
        }
        IRuntimeType[] rt = new IRuntimeType[list.size()];
        list.toArray(rt);
        return rt;
    }

    public static IServer[] getAvailableServersForModule(IModule module, boolean includeErrors, IProgressMonitor monitor) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                block10: {
                    if (!ServerUtil.containsModule(servers[i], module, monitor)) {
                        try {
                            IModule[] parents = servers[i].getRootModules(module, monitor);
                            if (parents != null && parents.length > 0) {
                                boolean found = false;
                                if (parents != null) {
                                    int size2 = parents.length;
                                    int j = 0;
                                    while (!found && j < size2) {
                                        IModule parent = parents[j];
                                        IStatus status = servers[i].canModifyModules(new IModule[]{parent}, new IModule[0], monitor);
                                        if (status == null || status.isOK()) {
                                            list.add(servers[i]);
                                            found = true;
                                        }
                                        ++j;
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!includeErrors) break block10;
                            list.add(servers[i]);
                        }
                    }
                }
                ++i;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    public static IServer[] getServersByModule(IModule module, IProgressMonitor monitor) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.containsModule(servers[i], module, monitor)) {
                    list.add(servers[i]);
                }
                ++i;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    public static boolean containsModule(IServer server, final IModule module, IProgressMonitor monitor) {
        if (server == null) {
            return false;
        }
        Trace.trace(Trace.FINEST, "containsModule() " + server + " " + module);
        class Helper {
            boolean b;

            Helper() {
            }
        }
        final Helper h = new Helper();
        ((Server)server).visit(new IModuleVisitor(){
            {
            }

            public boolean visit(IModule[] modules) {
                int size = modules.length;
                if (modules[size - 1].equals(module)) {
                    h.b = true;
                    return false;
                }
                return true;
            }
        }, null);
        return h.b;
    }

    public static IServer getServer(ILaunchConfiguration configuration) throws CoreException {
        String serverId = configuration.getAttribute("server-id", null);
        if (serverId != null) {
            return ServerCore.findServer(serverId);
        }
        return null;
    }

    public static IStatus validateEdit(Object context, IServer server) {
        return ((Server)server).validateEdit(context);
    }
}

