/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeTargetHandler;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.internal.IOrdered;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.RuntimeTargetHandlerDelegate;

public class RuntimeTargetHandler
implements IRuntimeTargetHandler,
IOrdered {
    private IConfigurationElement element;
    private RuntimeTargetHandlerDelegate delegate;

    public RuntimeTargetHandler(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            String o = this.element.getAttribute("order");
            return Integer.parseInt(o);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String[] getRuntimeTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("runtimeTypeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Could not parse runtime type ids: " + this.element);
            return null;
        }
    }

    public boolean supportsRuntimeType(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        String id = runtimeType.getId();
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getRuntimeTypeIds();
        if (s == null) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RuntimeTargetHandlerDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (RuntimeTargetHandlerDelegate)this.element.createExecutableExtension("class");
                this.delegate.initialize(this);
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public void setRuntimeTarget(IProject project, IRuntime runtime, IProgressMonitor monitor) {
        if (project == null || runtime == null) {
            return;
        }
        try {
            this.getDelegate().setRuntimeTarget(project, runtime, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
        }
    }

    public void removeRuntimeTarget(IProject project, IRuntime runtime, IProgressMonitor monitor) {
        if (project == null || runtime == null) {
            return;
        }
        try {
            this.getDelegate().removeRuntimeTarget(project, runtime, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
        }
    }

    public Object getAdapter(Class adapter) {
        RuntimeTargetHandlerDelegate delegate2 = this.getDelegate();
        if (adapter.isInstance(delegate2)) {
            return this.delegate;
        }
        return null;
    }

    public String toString() {
        return "RuntimeTargetHandler[" + this.getId() + "]";
    }
}

