/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class ServerPreferences {
    private static final String PREF_AUTO_RESTART = "auto-restart";
    private static final String PREF_AUTO_PUBLISH = "auto-publish";
    private static final String PREF_MODULE_START_TIMEOUT = "module-start-timeout";
    private static final String PREF_AUTO_PUBLISH_LOCAL = "auto-publish-local";
    private static final String PREF_AUTO_PUBLISH_LOCAL_TIME = "auto-publish-local-time";
    private static final String PREF_AUTO_PUBLISH_REMOTE = "auto-publish-remote";
    private static final String PREF_AUTO_PUBLISH_REMOTE_TIME = "auto-publish-remote-time";
    private static final String PREF_MACHINE_SPEED = "machine-speed";
    private Preferences preferences = ServerPlugin.getInstance().getPluginPreferences();
    protected static ServerPreferences instance;

    private ServerPreferences() {
    }

    public static ServerPreferences getInstance() {
        if (instance == null) {
            instance = new ServerPreferences();
        }
        return instance;
    }

    public boolean isAutoRestarting() {
        return this.preferences.getBoolean(PREF_AUTO_RESTART);
    }

    public boolean isDefaultAutoRestarting() {
        return false;
    }

    public boolean isAutoPublishing() {
        return this.preferences.getBoolean(PREF_AUTO_PUBLISH);
    }

    public boolean isDefaultAutoPublishing() {
        return true;
    }

    public void setAutoRestarting(boolean value) {
        this.preferences.setValue(PREF_AUTO_RESTART, value);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public void setAutoPublishing(boolean value) {
        this.preferences.setValue(PREF_AUTO_PUBLISH, value);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public int getModuleStartTimeout() {
        return this.preferences.getInt(PREF_MODULE_START_TIMEOUT);
    }

    public int getMachineSpeed() {
        return this.preferences.getInt(PREF_MACHINE_SPEED);
    }

    public int getDefaultMachineSpeed() {
        return 6;
    }

    public void setMachineSpeed(int speed) {
        this.preferences.setValue(PREF_MACHINE_SPEED, speed);
    }

    public boolean getDefaultAutoPublishLocal() {
        return false;
    }

    public boolean getAutoPublishLocal() {
        return this.preferences.getBoolean(PREF_AUTO_PUBLISH_LOCAL);
    }

    public void setAutoPublishLocal(boolean auto) {
        this.preferences.setValue(PREF_AUTO_PUBLISH_LOCAL, auto);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public int getDefaultAutoPublishLocalTime() {
        return 15;
    }

    public int getAutoPublishLocalTime() {
        return this.preferences.getInt(PREF_AUTO_PUBLISH_LOCAL_TIME);
    }

    public void setAutoPublishLocalTime(int auto) {
        this.preferences.setValue(PREF_AUTO_PUBLISH_LOCAL_TIME, auto);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public boolean getDefaultAutoPublishRemote() {
        return false;
    }

    public boolean getAutoPublishRemote() {
        return this.preferences.getBoolean(PREF_AUTO_PUBLISH_REMOTE);
    }

    public void setAutoPublishRemote(boolean auto) {
        this.preferences.setValue(PREF_AUTO_PUBLISH_REMOTE, auto);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public int getDefaultAutoPublishRemoteTime() {
        return 60;
    }

    public int getAutoPublishRemoteTime() {
        return this.preferences.getInt(PREF_AUTO_PUBLISH_REMOTE_TIME);
    }

    public void setAutoPublishRemoteTime(int auto) {
        this.preferences.setValue(PREF_AUTO_PUBLISH_REMOTE_TIME, auto);
        ServerPlugin.getInstance().savePluginPreferences();
    }

    public void setDefaults() {
        this.preferences.setDefault(PREF_AUTO_PUBLISH, this.isDefaultAutoPublishing());
        this.preferences.setDefault(PREF_AUTO_RESTART, this.isDefaultAutoRestarting());
        this.preferences.setDefault(PREF_MACHINE_SPEED, this.getDefaultMachineSpeed());
        this.preferences.setDefault(PREF_AUTO_PUBLISH_LOCAL, this.getDefaultAutoPublishLocal());
        this.preferences.setDefault(PREF_AUTO_PUBLISH_LOCAL_TIME, this.getDefaultAutoPublishLocalTime());
        this.preferences.setDefault(PREF_AUTO_PUBLISH_REMOTE, this.getDefaultAutoPublishRemote());
        this.preferences.setDefault(PREF_AUTO_PUBLISH_REMOTE_TIME, this.getDefaultAutoPublishRemoteTime());
        this.preferences.setDefault(PREF_MODULE_START_TIMEOUT, 300001);
        boolean save = false;
        if (this.preferences.isDefault(PREF_MODULE_START_TIMEOUT)) {
            this.preferences.setValue(PREF_MODULE_START_TIMEOUT, 300000);
            save = true;
        }
        if (save) {
            ServerPlugin.getInstance().savePluginPreferences();
        }
    }
}

