/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.palette.AbstractModelFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.osgi.framework.Bundle;

public class ModelFactoryForPlugins
extends AbstractModelFactory {
    private static ModelFactoryForPlugins instance = null;

    public static synchronized ModelFactoryForPlugins getInstance() {
        if (instance == null) {
            instance = new ModelFactoryForPlugins();
        }
        return instance;
    }

    protected void addDefinitionFromExtension(SnippetDefinitions definitions, IConfigurationElement element) {
        SnippetPaletteDrawer category;
        String name = element.getName();
        if (name.equals("category") && (category = this.createCategory(element)) != null) {
            this.assignSource(category, definitions, element);
            definitions.getCategories().add(category);
            IConfigurationElement[] children = element.getChildren("item");
            int i = 0;
            while (i < children.length) {
                IConfigurationElement child = children[i];
                SnippetPaletteItem item = this.createItem(child);
                if (item != null) {
                    this.setProperty(item, "category", (Object)element.getAttribute("id"));
                    this.assignSource(item, definitions, element);
                    definitions.getItems().add(item);
                }
                ++i;
            }
        }
    }

    protected void assignSource(ISnippetsEntry entry, SnippetDefinitions definitions, IConfigurationElement element) {
        entry.setSourceType("PLUGINS");
        ((PaletteEntry)entry).setUserModificationPermission(3);
        PluginRecord record = this.getPluginRecordFor(definitions, element);
        entry.setSourceDescriptor(record);
    }

    public SnippetPaletteDrawer createCategory(Object source) {
        SnippetPaletteDrawer result = super.createCategory(source);
        if (result != null) {
            result.setInitialState(1);
        }
        return result;
    }

    protected String[] getDefaultFilters() {
        return new String[]{"*"};
    }

    protected String getID(Object source) {
        if (source instanceof IConfigurationElement) {
            return ((IConfigurationElement)source).getAttribute("id");
        }
        return null;
    }

    protected PluginRecord getPluginRecordFor(SnippetDefinitions definitions, IConfigurationElement element) {
        String id = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)id);
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier identifier = new PluginVersionIdentifier(version);
        PluginRecord record = new PluginRecord();
        record.setPluginName(id);
        record.setPluginVersion(identifier.toString());
        return record;
    }

    public SnippetDefinitions loadCurrent() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.wst.common.snippets", "SnippetContributions");
        SnippetDefinitions definitions = new SnippetDefinitions();
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.addDefinitionFromExtension(definitions, elements[i]);
                ++i;
            }
        }
        this.connectItemsAndCategories(definitions);
        return definitions;
    }

    protected void setProperties(SnippetPaletteDrawer category, Object source) {
        if (!(source instanceof IConfigurationElement)) {
            return;
        }
        IConfigurationElement element = (IConfigurationElement)source;
        this.setProperty(category, "description", (Object)element.getAttribute("description"));
        this.setProperty(category, "icon", (Object)element.getAttribute("icon"));
        this.setProperty(category, "id", (Object)element.getAttribute("id"));
        this.setProperty(category, "label", (Object)element.getAttribute("label"));
        this.setProperty(category, "largeicon", (Object)element.getAttribute("largeicon"));
        String filtersAttr = element.getAttribute("filters");
        String[] filters = null;
        filters = filtersAttr != null ? StringUtils.asArray(element.getAttribute("filters")) : this.getDefaultFilters();
        this.setProperty(category, "filters", (Object)filters);
    }

    protected void setProperties(SnippetPaletteItem item, Object source) {
        if (!(source instanceof IConfigurationElement)) {
            return;
        }
        IConfigurationElement element = (IConfigurationElement)source;
        this.setProperty(item, "category", (Object)element.getAttribute("category"));
        this.setProperty(item, "class", (Object)element.getAttribute("class"));
        this.setProperty(item, "description", (Object)element.getAttribute("description"));
        this.setProperty(item, "editorclass", (Object)element.getAttribute("editorclass"));
        this.setProperty(item, "icon", (Object)element.getAttribute("icon"));
        this.setProperty(item, "id", (Object)element.getAttribute("id"));
        this.setProperty(item, "label", (Object)element.getAttribute("label"));
        this.setProperty(item, "largeicon", (Object)element.getAttribute("largeicon"));
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            ISnippetVariable var;
            if (children[i].getName().equals("content")) {
                this.setProperty(item, "content", (Object)children[i].getValue());
            } else if (children[i].getName().equals("variables")) {
                Iterator iterator = this.createVariables(children[i].getChildren()).iterator();
                while (iterator.hasNext()) {
                    item.addVariable((ISnippetVariable)iterator.next());
                }
            } else if (children[i].getName().equals("variable") && (var = this.createVariable(children[i])) != null) {
                item.addVariable(var);
            }
            ++i;
        }
    }

    protected void setProperties(SnippetVariable variable, Object source) {
        if (!(source instanceof IConfigurationElement)) {
            return;
        }
        IConfigurationElement element = (IConfigurationElement)source;
        this.setProperty(variable, "default", (Object)element.getAttribute("default"));
        this.setProperty(variable, "description", (Object)element.getAttribute("description"));
        this.setProperty(variable, "id", (Object)element.getAttribute("id"));
        this.setProperty(variable, "name", (Object)element.getAttribute("name"));
    }
}

