/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.common.snippets.internal.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.SnippetsPluginImageHelper;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;

public class SnippetImageDescriptorHelper {
    protected static SnippetImageDescriptorHelper instance = null;

    public static synchronized SnippetImageDescriptorHelper getInstance() {
        if (instance == null) {
            instance = new SnippetImageDescriptorHelper();
        }
        return instance;
    }

    protected ImageDescriptor getDefaultDescriptor() {
        return this.getImageDescriptor("icons/full/obj16/snippets.gif");
    }

    public ImageDescriptor getImageDescriptor(ISnippetCategory category) {
        return this.getImageDescriptor(category, false);
    }

    public ImageDescriptor getImageDescriptor(ISnippetCategory category, boolean largeIcon) {
        String iconName;
        String string = iconName = largeIcon ? category.getLargeIconName() : category.getIconName();
        if (largeIcon && (iconName == null || iconName.length() == 0)) {
            iconName = category.getIconName();
        }
        if (category == null || iconName == null || iconName.length() == 0) {
            return this.getDefaultDescriptor();
        }
        ImageDescriptor image = null;
        if (category.getSourceType() == "PLUGINS") {
            PluginRecord record = (PluginRecord)category.getSourceDescriptor();
            if (record != null && record.getPluginName() != null) {
                image = this.getInstalledImage(record.getPluginName(), iconName);
            }
        } else {
            image = this.getImageDescriptor(iconName);
        }
        if (image == null || image.equals(ImageDescriptor.getMissingImageDescriptor())) {
            image = this.getDefaultDescriptor();
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(ISnippetItem item) {
        return this.getImageDescriptor(item, false);
    }

    public ImageDescriptor getImageDescriptor(ISnippetItem item, boolean largeIcon) {
        String iconName;
        ImageDescriptor image = null;
        String string = iconName = largeIcon ? item.getLargeIconName() : item.getIconName();
        if (largeIcon && (iconName == null || iconName.length() == 0)) {
            iconName = item.getIconName();
        }
        if (item.getSourceType() == "PLUGINS") {
            PluginRecord record = (PluginRecord)item.getSourceDescriptor();
            if (record != null && record.getPluginName() != null && (image = this.getInstalledImage(record.getPluginName(), iconName)) == null && item.getCategory() != null) {
                image = this.getImageDescriptor(item.getCategory(), largeIcon);
            }
        } else {
            image = iconName == null || iconName.length() < 1 ? this.getImageDescriptor(item.getCategory(), largeIcon) : this.getImageDescriptor(iconName);
        }
        if (image == null || image.equals(ImageDescriptor.getMissingImageDescriptor())) {
            image = this.getDefaultDescriptor();
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        ImageDescriptor image = null;
        if (resource != null) {
            image = SnippetsPluginImageHelper.getInstance().getImageDescriptor(resource);
        }
        if (image == null || image.equals(ImageDescriptor.getMissingImageDescriptor())) {
            image = this.getDefaultDescriptor();
        }
        return image;
    }

    protected ImageDescriptor getInstalledImage(String plugin, String iconName) {
        Object image = null;
        if (iconName != null && iconName.length() > 0 && plugin != null) {
            image = SnippetsPluginImageHelper.getInstance().getImageDescriptor(iconName, plugin);
        }
        if (image == null || image.equals(ImageDescriptor.getMissingImageDescriptor())) {
            image = this.getDefaultDescriptor();
        }
        return image;
    }
}

