/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.editors.ISnippetEditor;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsCustomizer;
import org.osgi.framework.Bundle;

public class SnippetTemplateEntryPage
extends DefaultEntryPage
implements ModifyListener {
    public static final Class DEFAULT_EDITOR_CLASS;
    protected SnippetsCustomizer snippetsCustomizer = null;
    protected ISnippetEditor editor = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.snippets.internal.editors.VariableItemEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_EDITOR_CLASS = clazz;
    }

    public SnippetTemplateEntryPage(SnippetsCustomizer customizer) {
        this.snippetsCustomizer = customizer;
    }

    public void createControl(Composite parent, PaletteEntry entry) {
        super.createControl(parent, entry);
        this.editor = this.getEditor((ISnippetItem)entry);
        if (this.editor != null) {
            this.snippetsCustomizer.activeEditors.add(this.editor);
            this.editor.addModifyListener(this);
            this.editor.setItem((ISnippetItem)entry);
            this.editor.createContents((Composite)this.getControl());
            ((Composite)this.getControl()).setTabList(null);
        }
    }

    protected ISnippetEditor getEditor(ISnippetItem item) {
        boolean editorSpecified;
        PluginRecord pluginRecord;
        ISnippetEditor snippetEditor = null;
        String editorClassName = item.getEditorClassName();
        Bundle bundle = null;
        if (item.getSourceType() == "PLUGINS" && (pluginRecord = (PluginRecord)item.getSourceDescriptor()) != null) {
            bundle = Platform.getBundle((String)pluginRecord.getPluginName());
        }
        boolean bl = editorSpecified = editorClassName != null && editorClassName.length() > 0;
        if (editorSpecified) {
            Class<Object> theClass = null;
            try {
                if (editorClassName != null && editorClassName.length() > 0) {
                    ClassLoader classLoader;
                    theClass = bundle != null && bundle.getState() != 1 ? bundle.loadClass(editorClassName) : ((classLoader = ((Object)((Object)this)).getClass().getClassLoader()) != null ? classLoader.loadClass(editorClassName) : Class.forName(editorClassName));
                }
            }
            catch (ClassNotFoundException e) {
                Logger.logException("Could not load ISnippetEditor class", e);
            }
            if (theClass != null) {
                try {
                    snippetEditor = (ISnippetEditor)theClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    Logger.logException("Could not access ISnippetEditor class", e);
                }
                catch (InstantiationException e) {
                    Logger.logException("Could not instantiate ISnippetEditor class", e);
                }
            }
        }
        if (snippetEditor == null && !editorSpecified) {
            try {
                snippetEditor = (ISnippetEditor)DEFAULT_EDITOR_CLASS.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        }
        return snippetEditor;
    }

    public void modifyText(ModifyEvent e) {
        if (this.editor != null && this.editor.getItem() != null && this.editor.getItem().getLabel().trim().length() == 0) {
            this.getPageContainer().showProblem("");
        } else {
            this.getPageContainer().clearProblem();
        }
    }
}

