/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.ui.ValueChangedListener;

public class SnippetVariableTableViewer {
    protected List fLibraryVariables;
    protected ISnippetVariable fSelection;
    protected List fSelectionChangedListeners;
    protected TableViewer fTableViewer = null;
    protected List fValueChangedListeners;
    protected Hashtable fValues = null;

    public SnippetVariableTableViewer(Composite parent) {
        this.createContents(parent);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionChangedListeners().add(listener);
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.getValueChangeListeners().add(listener);
    }

    public Control createContents(Composite parent) {
        this.fTableViewer = new TableViewer(new Table(parent, 67588));
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                SnippetVariableTableViewer.this.fSelection = sel != null && !sel.isEmpty() && sel instanceof IStructuredSelection ? (ISnippetVariable)((IStructuredSelection)sel).getFirstElement() : null;
                SnippetVariableTableViewer.this.fireSelectionChanged(event);
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return null;
                }
                ISnippetVariable var = (ISnippetVariable)element;
                if (columnIndex == 0) {
                    return var.getId();
                }
                if (columnIndex == 1) {
                    return (String)SnippetVariableTableViewer.this.fValues.get(var.getId());
                }
                return "";
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(65, true));
        this.fTableViewer.getTable().setLayout((Layout)tlayout);
        TableColumn tc1 = new TableColumn(this.fTableViewer.getTable(), 0);
        tc1.setText("Variable ID");
        tc1.setResizable(true);
        tc1.setWidth(40);
        TableColumn tc2 = new TableColumn(this.fTableViewer.getTable(), 0);
        tc2.setText("Value");
        tc2.setResizable(true);
        tc2.setWidth(40);
        this.fTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.fTableViewer.getTable()), new TextCellEditor((Composite)this.fTableViewer.getTable())});
        this.fTableViewer.setColumnProperties(new String[]{"id", "value"});
        ICellModifier cellmodifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("value");
            }

            public Object getValue(Object element, String property) {
                if (property.equals("id")) {
                    return ((ISnippetVariable)element).getId();
                }
                if (property.equals("value")) {
                    return SnippetVariableTableViewer.this.fValues.get(((ISnippetVariable)element).getId());
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                ISnippetVariable var = (ISnippetVariable)item.getData();
                if (property.equals("value")) {
                    String oldValue = (String)SnippetVariableTableViewer.this.fValues.get(var.getId());
                    SnippetVariableTableViewer.this.fValues.put(var.getId(), value);
                    item.setText(1, (String)value);
                    SnippetVariableTableViewer.this.fireValueChanged(new String(var.getId()), property, oldValue, new String((String)value));
                }
            }
        };
        this.fTableViewer.setCellModifier(cellmodifier);
        this.fTableViewer.setInput((Object)this.getLibraryVariables());
        this.refresh();
        return this.getControl();
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        ISelectionChangedListener[] listeners = new ISelectionChangedListener[this.getSelectionChangedListeners().size()];
        this.getSelectionChangedListeners().toArray(listeners);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].selectionChanged(event);
            ++i;
        }
    }

    protected void fireValueChanged(String key, String property, String oldValue, String newValue) {
        ValueChangedListener[] listeners = new ValueChangedListener[this.getValueChangeListeners().size()];
        this.getValueChangeListeners().toArray(listeners);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(key, property, oldValue, newValue);
            ++i;
        }
    }

    public Control getControl() {
        return this.getTable();
    }

    public List getLibraryVariables() {
        if (this.fLibraryVariables == null) {
            this.fLibraryVariables = new ArrayList();
        }
        return this.fLibraryVariables;
    }

    public ISnippetVariable getSelectedVariable() {
        return this.fSelection;
    }

    protected List getSelectionChangedListeners() {
        if (this.fSelectionChangedListeners == null) {
            this.fSelectionChangedListeners = new ArrayList();
        }
        return this.fSelectionChangedListeners;
    }

    public Table getTable() {
        if (this.fTableViewer == null) {
            return null;
        }
        return this.fTableViewer.getTable();
    }

    public String getValue(ISnippetVariable var) {
        return this.getValue(var.getId());
    }

    public String getValue(String id) {
        if (this.getValues().containsKey(id)) {
            return (String)this.getValues().get(id);
        }
        return "";
    }

    protected List getValueChangeListeners() {
        if (this.fValueChangedListeners == null) {
            this.fValueChangedListeners = new ArrayList();
        }
        return this.fValueChangedListeners;
    }

    public Hashtable getValues() {
        if (this.fValues == null) {
            this.fValues = new Hashtable();
        }
        return this.fValues;
    }

    protected void refresh() {
        if (this.fLibraryVariables != null) {
            this.fValues = null;
            int i = 0;
            while (i < this.fLibraryVariables.size()) {
                ISnippetVariable var = (ISnippetVariable)this.fLibraryVariables.get(i);
                this.getValues().put(var.getId(), var.getDefaultValue());
                ++i;
            }
        }
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput((Object)this.fLibraryVariables);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionChangedListeners().remove(listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.getValueChangeListeners().remove(listener);
    }

    public void setLibraryVariables(List libraryVariables) {
        this.fLibraryVariables = libraryVariables;
        this.refresh();
    }
}

