/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class JSPTranslationExtension
extends JSPTranslation {
    private static final boolean DEBUG;
    private IDocument fJspDocument = null;
    private IDocument fJavaDocument = null;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jsptranslation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public JSPTranslationExtension(IDocument jspDocument, IDocument javaDocument, IJavaProject javaProj, JSPTranslator translator) {
        super(javaProj, translator);
        this.fJspDocument = jspDocument;
        this.fJavaDocument = javaDocument;
        this.addPositionsToDocuments();
    }

    public IDocument getJspDocument() {
        return this.fJspDocument;
    }

    public IDocument getJavaDocument() {
        return this.fJavaDocument;
    }

    public String getJavaText() {
        return this.getJavaDocument() != null ? this.getJavaDocument().get() : "";
    }

    public TextEdit getJspEdit(TextEdit javaEdit) {
        int i;
        if (javaEdit == null) {
            return null;
        }
        ArrayList<Object> jspEdits = new ArrayList<Object>();
        int offset = javaEdit.getOffset();
        int length = javaEdit.getLength();
        if (javaEdit instanceof MultiTextEdit && javaEdit.getChildren().length > 0) {
            IRegion r = TextEdit.getCoverage((TextEdit[])this.getAllEdits(javaEdit));
            offset = r.getOffset();
            length = r.getLength();
        }
        Position[] javaPositions = this.getJavaRanges(offset, length);
        Position[] jspPositions = new Position[javaPositions.length];
        PositionDelta[] deltas = new PositionDelta[javaPositions.length];
        int i2 = 0;
        while (i2 < javaPositions.length) {
            deltas[i2] = new PositionDelta(javaPositions[i2].offset, javaPositions[i2].length);
            if (!this.isIndirect(javaPositions[i2].offset)) {
                jspPositions[i2] = (Position)this.getJava2JspMap().get(javaPositions[i2]);
            }
            ++i2;
        }
        if (DEBUG) {
            System.out.println("================================================");
            System.out.println("deltas:");
            String javaText = this.getJavaText();
            i = 0;
            while (i < deltas.length) {
                System.out.println("pos[" + deltas[i].preOffset + ":" + deltas[i].preLength + "]" + javaText.substring(deltas[i].preOffset, deltas[i].preOffset + deltas[i].preLength));
                ++i;
            }
            System.out.println("===============================================");
        }
        try {
            javaEdit.apply(this.getJavaDocument());
        }
        catch (MalformedTreeException e) {
            Logger.logException(e);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        String newJavaText = this.getJavaDocument().get();
        if (DEBUG) {
            System.out.println("java post format text:\n" + newJavaText);
        }
        i = 0;
        while (i < javaPositions.length) {
            deltas[i].setPostEditData(javaPositions[i].offset, javaPositions[i].length, javaPositions[i].isDeleted);
            ++i;
        }
        Position jspPos = null;
        String replaceText = "";
        int i3 = 0;
        while (i3 < deltas.length) {
            jspPos = jspPositions[i3];
            if (jspPos != null) {
                if (deltas[i3].isDeleted) {
                    jspEdits.add(new DeleteEdit(jspPos.offset, jspPos.length));
                } else {
                    replaceText = newJavaText.substring(deltas[i3].postOffset, deltas[i3].postOffset + deltas[i3].postLength);
                    jspEdits.add(new ReplaceEdit(jspPos.offset, jspPos.length, replaceText));
                }
                if (DEBUG) {
                    this.debugReplace(deltas, jspPos, replaceText, i3);
                }
            } else if (this.isImport(javaPositions[i3].getOffset()) && replaceText.lastIndexOf("import ") != -1) {
                replaceText = newJavaText.substring(deltas[i3].postOffset, deltas[i3].postOffset + deltas[i3].postLength);
                String importText = replaceText.substring(replaceText.lastIndexOf("import "), replaceText.indexOf(";"));
                importText = "<%@page import=\"" + importText + "\" %>\n";
                jspEdits.add(new InsertEdit(0, importText));
            }
            ++i3;
        }
        return this.createMultiTextEdit(jspEdits.toArray(new TextEdit[jspEdits.size()]));
    }

    private TextEdit createMultiTextEdit(TextEdit[] edits) {
        if (edits.length == 0) {
            return new MultiTextEdit();
        }
        IRegion region = TextEdit.getCoverage((TextEdit[])edits);
        MultiTextEdit multiEdit = new MultiTextEdit(region.getOffset(), region.getLength());
        int i = 0;
        while (i < edits.length) {
            this.addToMultiEdit(edits[i], multiEdit);
            ++i;
        }
        return multiEdit;
    }

    private void addToMultiEdit(TextEdit edit, MultiTextEdit multiEdit) {
        TextEdit[] children = multiEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].covers(edit)) {
                return;
            }
            ++i;
        }
        multiEdit.addChild(edit);
    }

    private void addPositionsToDocuments() {
        if (this.getJavaDocument() != null && this.getJspDocument() != null) {
            HashMap java2jsp = this.getJava2JspMap();
            Iterator it = java2jsp.keySet().iterator();
            Position javaPos = null;
            while (it.hasNext()) {
                block6: {
                    javaPos = (Position)it.next();
                    try {
                        this.fJavaDocument.addPosition(javaPos);
                    }
                    catch (BadLocationException e) {
                        if (!DEBUG) break block6;
                        System.out.println("tyring to add Java Position:[" + javaPos.offset + ":" + javaPos.length + "] to " + this.getJavaPath());
                        Logger.logException(e);
                    }
                }
                try {
                    this.fJspDocument.addPosition((Position)java2jsp.get(javaPos));
                }
                catch (BadLocationException e) {
                    if (!DEBUG) continue;
                    System.out.println("tyring to add JSP Position:[" + ((Position)java2jsp.get((Object)javaPos)).offset + ":" + ((Position)java2jsp.get((Object)javaPos)).length + "] to " + this.getJavaPath());
                    Logger.logException(e);
                }
            }
        }
    }

    private TextEdit[] getAllEdits(TextEdit javaEdit) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        if (javaEdit instanceof MultiTextEdit) {
            TextEdit[] children = javaEdit.getChildren();
            int i = 0;
            while (i < children.length) {
                result.addAll(Arrays.asList(this.getAllEdits(children[i])));
                ++i;
            }
        } else {
            result.add(javaEdit);
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    private void debugReplace(PositionDelta[] deltas, Position jspPos, String replaceText, int i) {
        String jspChunk = this.getJspDocument().get().substring(jspPos.offset, jspPos.offset + jspPos.length);
        if (!deltas[i].isDeleted) {
            System.out.println("replacing:");
            System.out.println("jsp:[" + jspChunk + "]");
            System.out.println("w/ :[" + replaceText + "]");
            System.out.println("--------------------------------");
        }
    }

    private class PositionDelta {
        public boolean isDeleted = false;
        public int preOffset = 0;
        public int preLength = 0;
        public int postOffset = 0;
        public int postLength = 0;

        public PositionDelta(int preOffset, int preLength) {
            this.preOffset = preOffset;
            this.preLength = preLength;
        }

        public void setPostEditData(int postOffset, int postLength, boolean isDeleted) {
            this.postOffset = postOffset;
            this.postLength = postLength;
            this.isDeleted = isDeleted;
        }
    }
}

