/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.IValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.LocationHolder;

public class WSDL11ValidationInfoImpl
implements IWSDL11ValidationInfo {
    private IValidationInfo valinfo = null;
    private Hashtable elementlocations = null;
    private List schemas = new Vector();

    public WSDL11ValidationInfoImpl(IValidationInfo valinfo) {
        this.valinfo = valinfo;
    }

    public String getFileURI() {
        return this.valinfo.getFileURI();
    }

    public void addSchema(XSModel xsModel) {
        if (xsModel != null) {
            this.schemas.add(xsModel);
        }
    }

    public XSModel[] getSchemas() {
        return this.schemas.toArray(new XSModel[this.schemas.size()]);
    }

    public void clearSchemas() {
        this.schemas.clear();
    }

    public void setElementLocations(Hashtable elementLocations) {
        this.elementlocations = elementLocations;
    }

    public void addError(String message, Object element) {
        this.addError(message, element, null, null);
    }

    public void addError(String message, Object element, String errorKey, Object[] messageArguments) {
        if (this.elementlocations.containsKey(element)) {
            LocationHolder location = (LocationHolder)this.elementlocations.get(element);
            this.addError(message, location.getLine(), location.getColumn(), location.getURI(), errorKey, messageArguments);
        } else {
            this.addError(message, 0, 1, this.getFileURI());
        }
    }

    public void addWarning(String message, Object element) {
        if (this.elementlocations.containsKey(element)) {
            LocationHolder location = (LocationHolder)this.elementlocations.get(element);
            this.addWarning(message, location.getLine(), location.getColumn(), location.getURI());
        } else {
            this.addWarning(message, 0, 1, this.getFileURI());
        }
    }

    public void addError(String message, int line, int column, String uri) {
        this.addError(message, line, column, uri, null, null);
    }

    public void addError(String message, int line, int column, String uri, String errorKey, Object[] messageArguments) {
        try {
            ((ValidationInfoImpl)this.valinfo).addError(message, line, column, uri, errorKey, messageArguments);
        }
        catch (ClassCastException e) {
            System.err.println(e);
            this.valinfo.addError(message, line, column, uri);
        }
    }

    public void addWarning(String message, int line, int column, String uri) {
        this.valinfo.addWarning(message, line, column, uri);
    }

    public URIResolver getURIResolver() {
        return this.valinfo.getURIResolver();
    }
}

