/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXMLValidator
implements IXMLValidator {
    private final String _APACHE_FEATURE_CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    private final String _APACHE_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private final String _APACHE_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private final String _APACHE_FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private final String _APACHE_FEATURE_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private final String _APACHE_PROPERTY_EXTERNAL_SCHEMALOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private final String DEFINITIONS = "definitions";
    protected static final String IGNORE_ALWAYS = "IGNORE_ALWAYS";
    protected static final String PREMATURE_EOF = "PrematureEOF";
    protected Hashtable ingoredErrorKeyTable = new Hashtable();
    protected String uri;
    protected URIResolver uriResolver = null;
    protected List errors = new ArrayList();
    protected StringBuffer schemaLocationString = new StringBuffer();
    protected List ignoredNamespaceList = new ArrayList();
    protected InputStream inputStream = null;
    protected String currentErrorKey = null;
    protected Object[] currentMessageArguments = null;
    protected boolean isChildOfDoc = false;

    public DefaultXMLValidator() {
        this.ignoredNamespaceList.add("http://www.w3.org/1999/XMLSchema");
        this.ignoredNamespaceList.add("http://www.w3.org/2000/10/XMLSchema");
        this.ignoredNamespaceList.add("http://www.w3.org/2001/XMLSchema");
        this.ingoredErrorKeyTable.put(PREMATURE_EOF, IGNORE_ALWAYS);
    }

    public void setFile(String uri) {
        this.uri = uri;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void run() {
        try {
            InputSource validateInputSource;
            StringReader reader1 = null;
            StringReader reader2 = null;
            if (this.inputStream != null) {
                String string = this.createStringForInputStream(this.inputStream);
                reader1 = new StringReader(string);
                reader2 = new StringReader(string);
                validateInputSource = new InputSource(this.inputStream);
                validateInputSource.setCharacterStream(reader2);
            } else {
                validateInputSource = new InputSource(this.uri);
            }
            this.preparse(this.uri, reader1);
            SAXParser saxparser = this.createSAXParser();
            XMLConformanceDefaultHandler handler = new XMLConformanceDefaultHandler();
            saxparser.setErrorHandler((ErrorHandler)handler);
            saxparser.setEntityResolver((EntityResolver)handler);
            saxparser.setContentHandler((ContentHandler)handler);
            saxparser.parse(validateInputSource);
        }
        catch (SAXParseException e) {
            this.addError(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), this.uri);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {}
    }

    protected SAXParser createSAXParser() {
        SAXParser saxParser = null;
        try {
            try {
                MyStandardParserConfiguration configuration = new MyStandardParserConfiguration();
                saxParser = new SAXParser((XMLParserConfiguration)configuration);
                saxParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                saxParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                saxParser.setFeature("http://xml.org/sax/features/namespaces", true);
                saxParser.setFeature("http://xml.org/sax/features/validation", true);
                saxParser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            if (this.schemaLocationString.length() > 0) {
                saxParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)this.schemaLocationString.toString());
            }
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        return saxParser;
    }

    final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception exception) {}
        return fileString.toString();
    }

    protected void preparse(String uri, Reader characterStream) {
        javax.xml.parsers.SAXParser saxParser = null;
        try {
            InputSource inputSource;
            if (characterStream != null) {
                inputSource = new InputSource(uri);
                inputSource.setCharacterStream(characterStream);
            } else {
                inputSource = new InputSource(uri);
            }
            SAXParserFactoryImpl parserfactory = new SAXParserFactoryImpl();
            parserfactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parserfactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParser = parserfactory.newSAXParser();
            SchemaStringHandler handler = new SchemaStringHandler(uri);
            saxParser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List getErrors() {
        return this.errors;
    }

    protected void addError(String error, int line, int column, String uri) {
        this.errors.add(new ValidationMessageImpl(error, line, column, 0, uri, this.currentErrorKey, this.currentMessageArguments));
    }

    public void setSchemaLocation(String namespace, String location) {
        if (namespace != null && location != null && !namespace.equalsIgnoreCase("") && !location.equalsIgnoreCase("")) {
            this.schemaLocationString.append(" ").append(namespace).append(" ").append(this.formatURI(location));
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected String formatURI(String uri) {
        String space = "%20";
        StringBuffer newUri = new StringBuffer(uri);
        int newUriLength = newUri.length();
        int i = newUriLength - 1;
        while (i >= 0) {
            if (newUri.charAt(i) == ' ') {
                newUri.replace(i, i + 1, space);
            }
            --i;
        }
        return newUri.toString();
    }

    protected class XMLConformanceDefaultHandler
    extends DefaultHandler {
        protected XMLConformanceDefaultHandler() {
        }

        public void error(SAXParseException arg0) throws SAXException {
            String tempURI = arg0.getSystemId();
            if (DefaultXMLValidator.this.inputStream != null && arg0.getSystemId() == null) {
                tempURI = DefaultXMLValidator.this.uri;
            }
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), tempURI);
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), arg0.getSystemId());
        }

        public void warning(SAXParseException arg0) throws SAXException {
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), arg0.getSystemId());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("documentation") && (uri.equals("http://schemas.xmlsoap.org/wsdl/") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema"))) {
                DefaultXMLValidator.this.isChildOfDoc = false;
            }
            super.endElement(uri, localName, qName);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("documentation") && (uri.equals("http://schemas.xmlsoap.org/wsdl/") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema"))) {
                DefaultXMLValidator.this.isChildOfDoc = true;
            }
            super.startElement(uri, localName, qName, atts);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            IURIResolutionResult result;
            String uri;
            if (DefaultXMLValidator.this.isChildOfDoc) {
                return new InputSource();
            }
            if (publicId == null) {
                publicId = systemId;
            }
            if ((uri = (result = DefaultXMLValidator.this.uriResolver.resolve(null, publicId, systemId)).getPhysicalLocation()) != null && !uri.equals("")) {
                try {
                    URL entityURL = new URL(uri);
                    InputSource is = new InputSource(result.getLogicalLocation());
                    is.setByteStream(entityURL.openStream());
                    if (is != null) {
                        return is;
                    }
                }
                catch (Exception exception) {}
            }
            try {
                InputSource is = super.resolveEntity(publicId, systemId);
                if (is == null) {
                    throw new IOException();
                }
                return is;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    protected class SchemaStringHandler
    extends DefaultHandler {
        private final String XMLNS = "xmlns";
        private final String TARGETNAMESPACE = "targetNamespace";
        private String baselocation = null;

        public SchemaStringHandler(String baselocation) {
            this.baselocation = baselocation;
        }

        public void startElement(String uri, String localname, String arg2, Attributes attributes) throws SAXException {
            if (localname.equals("definitions")) {
                String targetNamespace = attributes.getValue("targetNamespace");
                int numAtts = attributes.getLength();
                int i = 0;
                while (i < numAtts) {
                    String namespace;
                    String attname = attributes.getQName(i);
                    if (attname.startsWith("xmlns") && !(namespace = attributes.getValue(i)).equals(targetNamespace) && !DefaultXMLValidator.this.ignoredNamespaceList.contains(namespace)) {
                        String resolvedURI = namespace;
                        DefaultXMLValidator.this.setSchemaLocation(namespace, resolvedURI);
                    }
                    ++i;
                }
            }
            super.startElement(uri, localname, arg2, attributes);
        }
    }

    protected class MyStandardParserConfiguration
    extends StandardParserConfiguration {
        protected XMLErrorReporter createErrorReporter() {
            return new XMLErrorReporter(this){
                final /* synthetic */ MyStandardParserConfiguration this$1;
                {
                    this.this$1 = myStandardParserConfiguration;
                }

                public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                    MyStandardParserConfiguration.access$0((MyStandardParserConfiguration)this.this$1).currentErrorKey = key;
                    MyStandardParserConfiguration.access$0((MyStandardParserConfiguration)this.this$1).currentMessageArguments = arguments;
                    super.reportError(domain, key, arguments, severity);
                }
            };
        }

        static /* synthetic */ DefaultXMLValidator access$0(MyStandardParserConfiguration myStandardParserConfiguration) {
            return myStandardParserConfiguration.DefaultXMLValidator.this;
        }
    }
}

