/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorViewerDescriptor;

public class NavigatorRegistryReader
extends RegistryReader {
    private static final String TAG_NAVIGATOR_CONTENT = "navigatorContent";
    private static final String TAG_NAVIGATOR_VIEW = "navigatorViewer";
    private static final String PL_NAVIGATOR_CONTENT = "navigatorContent";
    private static final String PL_NAVIGATOR_VIEW = "navigatorViewer";
    private NavigatorRegistry registry;

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("navigatorContent")) {
            try {
                NavigatorContentDescriptor desc = new NavigatorContentDescriptor(element);
                this.registry.add(desc);
            }
            catch (WorkbenchException e) {
                NavigatorPlugin.log("Unable to create navigator descriptor.", e.getStatus());
            }
            return true;
        }
        if (element.getName().equals("navigatorViewer")) {
            try {
                NavigatorViewerDescriptor desc = new NavigatorViewerDescriptor(element);
                this.registry.add(desc);
                return true;
            }
            catch (WorkbenchException e) {
                NavigatorPlugin.log("Unable to create navigator view descriptor.", e.getStatus());
            }
        }
        return false;
    }

    public void readRegistry(IExtensionRegistry in, NavigatorRegistry out) {
        this.registry = out;
        this.readRegistry(in, NavigatorPlugin.PLUGIN_ID, "navigatorContent");
        this.readRegistry(in, NavigatorPlugin.PLUGIN_ID, "navigatorViewer");
    }
}

