/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.sse.ui.internal.Logger;

public class StructuredMarkerAnnotation
extends MarkerAnnotation
implements IAnnotationPresentation {
    private IDebugModelPresentation fPresentation;
    private boolean fIsGrayed = false;
    String fAnnotationType = null;

    StructuredMarkerAnnotation(IMarker marker) {
        super(marker);
        this.initAnnotationType();
    }

    public final String getAnnotationType() {
        return this.fAnnotationType;
    }

    protected Image getImage(Display display) {
        Image image = null;
        if (this.fAnnotationType == "org.eclipse.wst.sse.ui.breakpoint") {
            IMarker marker;
            image = super.getImage(display);
            if (image == null && (marker = this.getMarker()) != null && marker.exists()) {
                image = this.fPresentation.getImage((Object)this.getMarker());
            }
        } else if (this.fAnnotationType == "org.eclipse.wst.sse.ui.temp.error") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        } else if (this.fAnnotationType == "org.eclipse.wst.sse.ui.temp.warning") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        } else if (this.fAnnotationType == "org.eclipse.wst.sse.ui.temp.info") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        } else if (this.fAnnotationType == "org.eclipse.ui.workbench.texteditor.task") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
        } else if (this.fAnnotationType == "org.eclipse.ui.workbench.texteditor.bookmark") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_BKMRK_TSK");
        }
        if (image != null && this.isGrayed()) {
            this.setImage(this.getGrayImage(display, image));
        } else {
            this.setImage(image);
        }
        return super.getImage(display);
    }

    private Image getGrayImage(Display display, Image image) {
        if (image != null) {
            String key = Integer.toString(image.hashCode());
            Image grayImage = JFaceResources.getImageRegistry().get(key);
            if (grayImage == null) {
                grayImage = new Image((Device)display, image, 2);
                JFaceResources.getImageRegistry().put(key, grayImage);
            }
            image = grayImage;
        }
        return image;
    }

    public final boolean isGrayed() {
        return this.fIsGrayed;
    }

    public final void setGrayed(boolean grayed) {
        this.fIsGrayed = grayed;
    }

    protected void initAnnotationType() {
        IMarker marker = this.getMarker();
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)IBreakpoint.BREAKPOINT_MARKER)) {
            if (this.fPresentation == null) {
                this.fPresentation = DebugUITools.newDebugModelPresentation();
            }
            this.setImage(null);
            this.setLayer(4);
            this.fAnnotationType = "org.eclipse.wst.sse.ui.breakpoint";
        } else {
            this.fAnnotationType = "org.eclipse.text.annotation.unknown";
            try {
                if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    int severity = marker.getAttribute("severity", -1);
                    switch (severity) {
                        case 2: {
                            this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.error";
                            break;
                        }
                        case 1: {
                            this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 0: {
                            this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.info";
                        }
                    }
                } else if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                    this.fAnnotationType = "org.eclipse.ui.workbench.texteditor.task";
                } else if (marker.isSubtypeOf("org.eclipse.search.searchmarker")) {
                    this.fAnnotationType = "org.eclipse.text.annotation.unknown";
                } else if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                    this.fAnnotationType = "org.eclipse.ui.workbench.texteditor.bookmark";
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }
}

