/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.contentproperties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.ContentSettings;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.ContentSettingsFileHandler;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.ContentSettingsSelfHandler;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.IContentSettingsHandler;

public class ContentSettingsSynchronizer
implements IResourceChangeListener {
    private static ContentSettingsSynchronizer instance = null;
    private ContentSettingsVisitor csVisitor;
    private boolean fListening = false;
    private IProject fProject;

    public static synchronized ContentSettingsSynchronizer getInstance() {
        if (instance == null) {
            instance = new ContentSettingsSynchronizer();
        }
        return instance;
    }

    Display getDisplay() {
        IWorkbench workbench = null;
        if (PlatformUI.isWorkbenchRunning()) {
            workbench = PlatformUI.getWorkbench();
        }
        if (workbench != null) {
            return workbench.getDisplay();
        }
        return null;
    }

    private final IProject getProject() {
        return this.fProject;
    }

    private final IWorkspace getWorkspace() {
        if (this.getProject() == null) {
            return ResourcesPlugin.getWorkspace();
        }
        return this.getProject().getWorkspace();
    }

    public synchronized void install() {
        if (!this.fListening) {
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 9);
            this.fListening = true;
        }
    }

    public synchronized boolean isListening() {
        return this.fListening;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                if (this.csVisitor == null) {
                    this.csVisitor = new ContentSettingsVisitor(event);
                }
                delta.accept((IResourceDeltaVisitor)this.csVisitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        this.csVisitor = null;
    }

    public synchronized void unInstall() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.fListening = false;
    }

    class ContentSettingsVisitor
    implements IResourceDeltaVisitor {
        private String contentSettingsName = ContentSettings.getContentSettingsName();
        private IResourceChangeEvent fEvent;
        private IContentSettingsHandler handler;

        public ContentSettingsVisitor(IResourceChangeEvent event) {
            this.fEvent = event;
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            if (delta.getKind() == 4 && delta.getFlags() == 0) {
                return true;
            }
            int resourceType = resource.getType();
            switch (resourceType) {
                case 4: {
                    return false;
                }
                case 1: {
                    IProject project = delta.getResource().getProject();
                    if (this.fEvent.getType() == 1 && resource.equals((Object)project.getFile(this.contentSettingsName))) {
                        this.handler = new ContentSettingsSelfHandler();
                        break;
                    }
                    if (this.fEvent.getType() == 8 && resource.getFileExtension() != null) {
                        if (!resource.getFileExtension().equalsIgnoreCase("shtml") && !resource.getFileExtension().equalsIgnoreCase("htm") && !resource.getFileExtension().equalsIgnoreCase("html") && !resource.getFileExtension().equalsIgnoreCase("jhtml") && !resource.getFileExtension().equalsIgnoreCase("xhtml") && !resource.getFileExtension().equalsIgnoreCase("jsp") && !resource.getFileExtension().equalsIgnoreCase("css") && !resource.getFileExtension().equalsIgnoreCase("jsf") && !resource.getFileExtension().equalsIgnoreCase("jspf")) break;
                        this.handler = new ContentSettingsFileHandler();
                        this.handler.handle(delta);
                        this.handler = null;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return true;
                }
                default: {
                    return true;
                }
            }
            IResourceDelta fDelta = delta;
            IContentSettingsHandler deltaHandler = this.handler;
            Display display = ContentSettingsSynchronizer.this.getDisplay();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(this, deltaHandler, fDelta){
                    final /* synthetic */ ContentSettingsVisitor this$1;
                    private final /* synthetic */ IContentSettingsHandler val$deltaHandler;
                    private final /* synthetic */ IResourceDelta val$fDelta;
                    {
                        this.this$1 = contentSettingsVisitor;
                        this.val$deltaHandler = iContentSettingsHandler;
                        this.val$fDelta = iResourceDelta;
                    }

                    public void run() {
                        if (this.val$deltaHandler != null) {
                            this.val$deltaHandler.handle(this.val$fDelta);
                        }
                    }
                });
            } else if (deltaHandler != null) {
                deltaHandler.handle(fDelta);
            }
            this.handler = null;
            return true;
        }
    }
}

