/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.reconcile.AbstractStructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.DirtyRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;

public class StructuredRegionProcessor
extends DirtyRegionProcessor
implements IStructuredDocumentListener,
IModelLifecycleListener {
    private SourceTextInputListener fTextInputListener = null;
    private IReconcilingStrategy fDefaultStrategy;
    private ValidatorStrategy fValidatorStrategy;

    public IReconcilingStrategy getDefaultStrategy() {
        return this.fDefaultStrategy;
    }

    protected IReconcilingStrategy getStrategy(DirtyRegion dirtyRegion) {
        IReconcilingStrategy strategy = super.getStrategy(dirtyRegion);
        if (strategy == null) {
            strategy = this.getDefaultStrategy();
        }
        return strategy;
    }

    public ValidatorStrategy getValidatorStrategy() {
        return this.fValidatorStrategy;
    }

    protected void process(DirtyRegion dirtyRegion) {
        if (!this.isInstalled()) {
            return;
        }
        ITypedRegion[] unfiltered = this.computePartitioning(dirtyRegion);
        ITypedRegion[] filtered = this.filterTotalScopeRegions(unfiltered);
        DirtyRegion dirty = null;
        int i = 0;
        while (i < filtered.length) {
            dirty = this.createDirtyRegion(filtered[i], "__insert");
            IReconcilingStrategy s = this.getReconcilingStrategy(filtered[i].getType());
            if (s != null && dirty != null) {
                s.reconcile(dirty, (IRegion)dirty);
            }
            if (this.fValidatorStrategy != null) {
                this.fValidatorStrategy.reconcile(filtered[i], dirty);
            }
            ++i;
        }
    }

    private ITypedRegion[] filterTotalScopeRegions(ITypedRegion[] unfiltered) {
        IReconcilingStrategy s = null;
        HashMap<String, ITypedRegion> totalScopeRegions = new HashMap<String, ITypedRegion>();
        HashMap<String, ITypedRegion> partialScopeRegions = new HashMap<String, ITypedRegion>();
        ArrayList allRegions = new ArrayList();
        int i = 0;
        while (i < unfiltered.length) {
            String partitionType = unfiltered[i].getType();
            if (!totalScopeRegions.containsKey(partitionType) && !partialScopeRegions.containsKey(partitionType)) {
                ValidatorStrategy validatorStrategy;
                s = this.getReconcilingStrategy(partitionType);
                if (s == null && (validatorStrategy = this.getValidatorStrategy()) != null && validatorStrategy.canValidatePartition(partitionType)) {
                    s = validatorStrategy;
                }
                if (s instanceof AbstractStructuredTextReconcilingStrategy) {
                    if (((AbstractStructuredTextReconcilingStrategy)s).isTotalScope()) {
                        totalScopeRegions.put(partitionType, unfiltered[i]);
                    } else {
                        partialScopeRegions.put(partitionType, unfiltered[i]);
                    }
                } else {
                    partialScopeRegions.put(partitionType, unfiltered[i]);
                }
            }
            ++i;
        }
        allRegions.addAll(totalScopeRegions.values());
        allRegions.addAll(partialScopeRegions.values());
        ITypedRegion[] filtered = allRegions.toArray(new ITypedRegion[allRegions.size()]);
        if (DEBUG) {
            System.out.println("filtered out this many 'total-scope' regions: " + (unfiltered.length - filtered.length));
        }
        return filtered;
    }

    public void setDefaultStrategy(IReconcilingStrategy defaultStrategy) {
        this.fDefaultStrategy = defaultStrategy;
        if (this.fDefaultStrategy != null) {
            this.fDefaultStrategy.setDocument(this.getDocument());
            if (this.fDefaultStrategy instanceof IReconcilingStrategyExtension) {
                ((IReconcilingStrategyExtension)this.fDefaultStrategy).setProgressMonitor(this.getLocalProgressMonitor());
            }
        }
    }

    protected void setDocumentOnAllStrategies(IDocument document) {
        super.setDocumentOnAllStrategies(document);
        IReconcilingStrategy defaultStrategy = this.getDefaultStrategy();
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (defaultStrategy != null) {
            defaultStrategy.setDocument(document);
        }
        if (validatorStrategy != null) {
            validatorStrategy.setDocument(document);
        }
    }

    public void setValidatorStrategy(ValidatorStrategy validatorStrategy) {
        this.fValidatorStrategy = validatorStrategy;
        if (this.fValidatorStrategy != null) {
            this.fValidatorStrategy.setDocument(this.getDocument());
            this.fValidatorStrategy.setProgressMonitor(this.getLocalProgressMonitor());
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean contains(DirtyRegion root, DirtyRegion possible) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 195->198)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStructuredModel getStructuredModelForRead(IDocument doc) {
        IStructuredModel sModel = null;
        if (doc != null) {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        }
        return sModel;
    }

    public void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.isInstalled()) {
            this.reconcilerDocumentChanged(newInput);
            this.setDocument(newInput);
            this.setDocumentOnAllStrategies(newInput);
            this.setEntireDocumentDirty(newInput);
        }
    }

    /*
     * Exception decompiling
     */
    private void hookUpModelLifecycleListener(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 41->45)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fTextInputListener = new SourceTextInputListener();
        textViewer.addTextInputListener((ITextInputListener)this.fTextInputListener);
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
        this.reconcilerDocumentChanged(structuredDocumentEvent.getDocument());
    }

    public void noChange(NoChangeEvent structuredDocumentEvent) {
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
        if (DEBUG) {
            System.out.println("[trace reconciler] >StructuredRegionProcessor: *NODES REPLACED");
        }
        DirtyRegion dr = this.partitionChanged(structuredDocumentEvent) ? this.createDirtyRegion(0, this.getDocument().getLength(), "__insert") : this.createDirtyRegion(structuredDocumentEvent.getOffset(), structuredDocumentEvent.getLength(), "__insert");
        this.processDirtyRegion(dr);
    }

    private boolean partitionChanged(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
        boolean changed = false;
        IDocumentPartitioner partitioner = structuredDocumentEvent.getStructuredDocument().getDocumentPartitioner();
        if (partitioner != null) {
            IStructuredDocumentRegion newNode;
            IStructuredDocumentRegion oldNode;
            IStructuredDocumentRegionList oldNodes = structuredDocumentEvent.getOldStructuredDocumentRegions();
            IStructuredDocumentRegionList newNodes = structuredDocumentEvent.getNewStructuredDocumentRegions();
            oldNode = oldNodes.getLength() > 0 ? (oldNode = oldNodes.item(0)) : null;
            IStructuredDocumentRegion iStructuredDocumentRegion = newNode = newNodes.getLength() > 0 ? newNodes.item(0) : null;
            if (oldNode != null && newNode != null) {
                changed = partitioner.getContentType(oldNode.getStartOffset()).equals(partitioner.getContentType(newNode.getStartOffset()));
            }
        }
        return changed;
    }

    /*
     * Exception decompiling
     */
    public void processPostModelEvent(ModelLifecycleEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 127->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
        if (event.getType() == 3) {
            this.getDirtyRegionQueue().clear();
        }
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
        IDocument currentDoc = this.getDocument();
        this.unhookModelLifecycleListener(currentDoc);
        if (newDocument != null) {
            this.hookUpModelLifecycleListener(newDocument);
        }
        if (currentDoc != null && currentDoc instanceof IStructuredDocument) {
            ((IStructuredDocument)currentDoc).removeDocumentChangedListener((IStructuredDocumentListener)this);
        }
        if (newDocument != null && newDocument instanceof IStructuredDocument) {
            ((IStructuredDocument)newDocument).addDocumentChangedListener((IStructuredDocumentListener)this);
        }
        super.reconcilerDocumentChanged(newDocument);
    }

    public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
        if (DEBUG) {
            System.out.println("[trace reconciler] >StructuredRegionProcessor: *REGION CHANGED: \r\n\r\n created dirty region from flat model event >> :" + structuredDocumentEvent.getOffset() + ":" + structuredDocumentEvent.getLength() + "\r\n");
        }
        String dirtyRegionType = structuredDocumentEvent.getDeletedText().equals("") ? "__insert" : "__remove";
        DirtyRegion dr = this.createDirtyRegion(structuredDocumentEvent.getOffset(), structuredDocumentEvent.getLength(), dirtyRegionType);
        this.processDirtyRegion(dr);
    }

    public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
        if (DEBUG) {
            System.out.println("[trace reconciler] >StructuredRegionProcessor: *REGIONS REPLACED: \r\n\r\n created dirty region from flat model event >> :" + structuredDocumentEvent.getOffset() + ":" + structuredDocumentEvent.getLength() + "\n");
        }
        DirtyRegion dr = this.createDirtyRegion(structuredDocumentEvent.getOffset(), structuredDocumentEvent.getLength(), "__insert");
        this.processDirtyRegion(dr);
    }

    protected void setEntireDocumentDirty(IDocument document) {
        if (document != null && this.isInstalled()) {
            this.getDirtyRegionQueue().clear();
            DirtyRegion entireDocument = this.createDirtyRegion(0, document.getLength(), "__insert");
            this.processDirtyRegion(entireDocument);
        }
    }

    /*
     * Exception decompiling
     */
    private void unhookModelLifecycleListener(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 41->45)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.getLocalProgressMonitor().setCanceled(true);
            this.cancel();
            this.unhookModelLifecycleListener(this.getDocument());
            this.reconcilerDocumentChanged(null);
            this.getTextViewer().removeTextInputListener((ITextInputListener)this.fTextInputListener);
            List strategyTypes = this.getStrategyTypes();
            if (!strategyTypes.isEmpty()) {
                Iterator it = strategyTypes.iterator();
                IReconcilingStrategy strategy = null;
                while (it.hasNext()) {
                    strategy = this.getReconcilingStrategy((String)it.next());
                    if (!(strategy instanceof IReleasable)) continue;
                    ((IReleasable)strategy).release();
                    strategy = null;
                }
            }
        }
        super.uninstall();
    }

    private class SourceTextInputListener
    implements ITextInputListener {
        SourceTextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            StructuredRegionProcessor.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

