/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.search.OccurrencesSearchQuery;

public class BasicFindOccurrencesAction
extends TextEditorAction {
    private IStructuredDocument fDocument = null;
    private IFile fFile = null;
    private String fMatchRegionType = null;
    private String fMatchText = null;

    public BasicFindOccurrencesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    private void configure(StructuredTextEditor editor, IStructuredDocumentRegion sdRegion, ITextRegion r, String type) {
        this.fFile = editor.getFileInEditor();
        this.fDocument = (IStructuredDocument)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fMatchText = sdRegion.getText(r);
        this.fMatchRegionType = type;
    }

    public boolean enabledForParitition(String partitionType) {
        String[] accept = this.getPartitionTypes();
        int i = 0;
        while (i < accept.length) {
            if (partitionType.equals(accept[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean enabledForRegionType(String regionType) {
        String[] accept = this.getRegionTypes();
        int i = 0;
        while (i < accept.length) {
            if (regionType.equals(accept[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] getPartitionTypes() {
        return new String[0];
    }

    protected String[] getRegionTypes() {
        return new String[0];
    }

    public ISearchQuery getSearchQuery() {
        return new OccurrencesSearchQuery(this.fFile, this.fDocument, this.fMatchText, this.fMatchRegionType);
    }

    public void run() {
        if (this.fDocument != null && this.fMatchText != null && this.fMatchRegionType != null) {
            NewSearchUI.runQuery((ISearchQuery)this.getSearchQuery());
        }
        this.unconfigure();
    }

    private void unconfigure() {
        this.fFile = null;
        this.fDocument = null;
    }

    public void update() {
        super.update();
        ITextEditor editor = this.getTextEditor();
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextRegion r;
            IStructuredDocumentRegion sdRegion;
            ITextSelection textSelection = (ITextSelection)selection;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            if (document instanceof IStructuredDocument && (sdRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(textSelection.getOffset())) != null && (r = sdRegion.getRegionAtCharacterOffset(textSelection.getOffset())) != null) {
                String type = r.getType();
                if (this.enabledForRegionType(type) && editor instanceof StructuredTextEditor) {
                    this.configure((StructuredTextEditor)editor, sdRegion, r, type);
                    this.setEnabled(true);
                } else {
                    this.unconfigure();
                    this.setEnabled(false);
                }
            }
        }
    }
}

