/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.w3c.dom.Node;

public abstract class StructureSelectAction
extends Action {
    protected StructuredTextEditor fEditor = null;
    protected SelectionHistory fHistory;
    protected IStructuredModel fModel = null;
    protected StructuredTextViewer fViewer = null;

    public StructureSelectAction(StructuredTextEditor editor, SelectionHistory history) {
        Assert.isNotNull((Object)((Object)editor));
        Assert.isNotNull((Object)history);
        this.fEditor = editor;
        this.fHistory = history;
        this.fViewer = editor.getTextViewer();
        this.fModel = editor.getModel();
        Assert.isNotNull((Object)((Object)this.fViewer));
    }

    protected abstract IndexedRegion getCursorIndexedRegion();

    protected IndexedRegion getIndexedRegion(int offset) {
        IndexedRegion indexedRegion = null;
        int lastOffset = offset;
        indexedRegion = this.fModel.getIndexedRegion(lastOffset);
        while (indexedRegion == null && lastOffset >= 0) {
            indexedRegion = this.fModel.getIndexedRegion(--lastOffset);
        }
        return indexedRegion;
    }

    protected abstract Region getNewSelectionRegion(Node var1, Region var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Region currentRegion = new Region(this.fViewer.getSelectedRange().x, this.fViewer.getSelectedRange().y);
        if (currentRegion.getLength() == this.fViewer.getDocument().getLength()) {
            return;
        }
        IndexedRegion cursorIndexedRegion = this.getCursorIndexedRegion();
        if (!(cursorIndexedRegion instanceof Node)) return;
        Node cursorNode = (Node)cursorIndexedRegion;
        if (cursorNode.getNodeType() == 3 && cursorNode.getNodeValue().trim().length() == 0 && (cursorNode = cursorNode.getParentNode()) instanceof IndexedRegion) {
            cursorIndexedRegion = (IndexedRegion)cursorNode;
        }
        Region cursorNodeRegion = new Region(cursorIndexedRegion.getStartOffset(), cursorIndexedRegion.getEndOffset() - cursorIndexedRegion.getStartOffset());
        Region newRegion = null;
        newRegion = cursorNodeRegion.getOffset() >= currentRegion.getOffset() && cursorNodeRegion.getOffset() <= currentRegion.getOffset() + currentRegion.getLength() && cursorNodeRegion.getOffset() + cursorNodeRegion.getLength() >= currentRegion.getOffset() && cursorNodeRegion.getOffset() + cursorNodeRegion.getLength() <= currentRegion.getOffset() + currentRegion.getLength() ? this.getNewSelectionRegion(cursorNode, currentRegion) : cursorNodeRegion;
        if (newRegion == null) return;
        this.fHistory.remember((IRegion)currentRegion);
        try {
            this.fHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRegion.getOffset(), newRegion.getLength());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fHistory.listenToSelectionChanges();
            return;
        }
    }
}

