/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.editor;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.wst.rdb.data.internal.core.editor.*;
import org.eclipse.wst.rdb.data.internal.ui.*;


public class TableDataContentProvider implements IStructuredContentProvider {

    protected ITableData tableData;

    
    public void dispose() {

    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.tableData = (ITableData)newInput;
    }

    public Object[] getElements(Object inputElement) {
        if (tableData==null)
            return new String[] {};       
        
        try {
            Vector rows = tableData.getRows();
            int rc = rows.size();
        	if (!tableData.isReadonly())
        	    rc++;
            Object[] a = new Object[rc];
            tableData.getRows().toArray(a);   
            if (!tableData.isReadonly())
                a[rc-1] = new Object();  //insertion row
            return a;
        } catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(IStatus.ERROR, 0, ex.getMessage(), ex);
            return new Object[] {};
        }
    }

}
