/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Jens Lukowski/Innoopract - initial renaming/restructuring
 *     
 *******************************************************************************/
package org.eclipse.wst.sse.ui.internal.properties;



import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;


public class AdapterPropertySourceProvider implements IPropertySourceProvider {

	public AdapterPropertySourceProvider() {
		super();
	}

	public IPropertySource getPropertySource(Object object) {
		if (object instanceof INodeNotifier) {
			return (IPropertySource) ((INodeNotifier) object).getAdapterFor(IPropertySource.class);
		}
		return null;
	}
}
