/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.jst.j2ee.internal.ejb.project.operations;



import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class EJBCreationResourceHandler {

	public static final String CLIENT_SAME_NAME_AS_EJB = "1"; //$NON-NLS-1$
	public static final String CLIENT_SAME_NAME_AS_EAR = "2"; //$NON-NLS-1$


	private static ResourceBundle fgResourceBundle;

	/**
	 * Returns the resource bundle used by all classes in this Project
	 */
	public static ResourceBundle getResourceBundle() {
		try {
			return ResourceBundle.getBundle("ejbcreation");//$NON-NLS-1$
		} catch (MissingResourceException e) {
			// does nothing - this method will return null and
			// getString(String, String) will return the key
			// it was called with
		}
		return null;
	}

	public static String getString(String key) {
		if (fgResourceBundle == null) {
			fgResourceBundle = getResourceBundle();
		}

		if (fgResourceBundle != null) {
			try {
				return fgResourceBundle.getString(key);
			} catch (MissingResourceException e) {
				return "!" + key + "!";//$NON-NLS-2$//$NON-NLS-1$
			}
		}
		return "!" + key + "!";//$NON-NLS-2$//$NON-NLS-1$
	}

	public static String getString(String key, Object[] substitutions) {
		return MessageFormat.format(getString(key), substitutions);
	}

	public static void nlsConcatenationFinder() {
		// used to tag methods which have concatenated strings
	}

}