/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.sql.Connection;
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.server.extensions.internal.editorlaunch.LaunchEditor;
import org.eclipse.wst.rdb.server.extensions.internal.templates.TemplateRegistry;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;


public abstract class Action implements IViewActionDelegate {

    protected IStructuredSelection selection = null;
    protected Connection connection = null;
    protected Database database = null;
    protected Schema schema = null;
    protected Table table = null;
    protected DatabaseDefinition dbDef = null;
    protected TemplateRegistry templates = null;
    protected LaunchEditor editLaunch = null;

   /* (non-Javadoc)
    * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
    */
   public abstract void run(IAction action);

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection) selection;
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate2#init(org.eclipse.jface.action.IAction)
     */
    public void init(IViewPart view) {
    }

    public void launchSQLEditor(String templateName, String title) {
        
    	String ddl = getTemplateRegistry().getDefaultDDL(templateName, Utility.getVendorType(database)); ;
    	// If the DDL has a schema tag (<schema>) , replace it with the actual schema name
    	if (schema != null) {   	    
    		ddl = ddl.replaceAll("<schema>",schema.getName()); //$NON-NLS-1$
    	}           
    	// If the DDL has a schema tag (<table>) , replace it with the actual table name
    	if (table != null) {    	    
    		ddl = ddl.replaceAll("<table>",table.getName()); //$NON-NLS-1$
    	}
    		 
        getEditorLaunch().launchSQLEditor(ddl, Utility.getConnectionInfo(database), title);
    }
    
    
    private TemplateRegistry getTemplateRegistry(){
    	if (templates == null)
            templates = TemplateRegistry.getTemplateRegistry();
    	return templates;
    }
    
    protected LaunchEditor getEditorLaunch(){
    	if (editLaunch == null)
            editLaunch = new LaunchEditor();
    	return editLaunch;
    }
    

    protected void init() {            
     	 // database and connection can change from invocation to invocation
       if (!this.selection.isEmpty()) {
          database = null;
          for (Iterator iter = this.selection.iterator(); iter.hasNext();) {
             Object obj = iter.next();
             if (obj instanceof IVirtualNode) {
                //Selected item is object folder
                Object parent = ((IVirtualNode) obj).getParent();
                ICatalogObject catalogObject = null;
                
                while (parent != null && catalogObject == null) {
                   if (parent instanceof IVirtualNode) {
                      parent = ((IVirtualNode) parent).getParent();
                   } 
                   else if (parent instanceof ICatalogObject) {
                      catalogObject = (ICatalogObject) parent;
                      break;
                   }
                   else if (parent instanceof Schema) {
                      database = ((Schema)parent).getDatabase();
                      schema = (Schema)parent;
                      connection = Utility.getConnectionInfo(database).getSharedConnection();
                      dbDef = Utility.getDBDef(database);
                      break;
                   }
                   else
                      break;
                }

                if (database == null && catalogObject != null) {
                   if (catalogObject instanceof Schema){
                      schema = (Schema)catalogObject;
                   } 
                   else if (catalogObject instanceof Table) {
                      table = (Table)catalogObject;
                      schema = table.getSchema();
                   }
                   database = catalogObject.getCatalogDatabase();
                   connection = ((ICatalogObject) catalogObject).getConnection();
                   dbDef = Utility.getDBDef(database);
                }
             } 
             else if (obj instanceof ICatalogObject) {	
					database = ((ICatalogObject) obj).getCatalogDatabase();
					connection = ((ICatalogObject) obj).getConnection();
					dbDef = Utility.getDBDef(database);
             }
             else if (obj instanceof Schema) {
                database = ((Schema)obj).getDatabase();
                connection = Utility.getConnectionInfo(database).getSharedConnection();
                dbDef = Utility.getDBDef(database);                
             }
			}
		}
    }

}