/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.schema;

import java.math.BigInteger;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Identity Specifier</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 4.14.4 Identity columns
 * 
 * The columns of a base table BT can optionally include not more than one identity column. The declared type of an identity column is either an exact numeric type with scale 0 (zero), INTEGER for example, or a distinct type whose source type is an exact numeric type with scale 0 (zero). An identity column has a start value, an increment, a maximum value, a minimum value, and a cycle option.
 * 
 * 
 * An identity column is associated with an internal sequence generator SG. Let IC be the identity column of BT. When a row R is presented for insertion into BT, if R does not contain a column corresponding to IC, then the value V for IC in the row inserted into BT is obtained by applying the General Rules of Subclause 9.21, "Generation of the next value of a sequence generator", to SG. The definition of an identity column may specify GENERATED ALWAYS or GENERATED BY DEFAULT.
 * 
 * NOTE 24: "Start value", "increment", "maximum value", "minimum value", and "cycle option" are defined in Subclause 4.21, "Sequence generators".
 * 
 * NOTE 25: The notion of an internal sequence generator being associated with an identity column is used only for definitional purposes in this International Standard.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getGenerationType <em>Generation Type</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getStartValue <em>Start Value</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getIncrement <em>Increment</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getMinimum <em>Minimum</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getMaximum <em>Maximum</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#isCycleOption <em>Cycle Option</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier()
 * @model 
 * @generated
 */
public interface IdentitySpecifier extends SQLObject{
	/**
	 * Returns the value of the '<em><b>Generation Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.wst.rdb.internal.models.sql.schema.GenerateType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Generation Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Generation Type</em>' attribute.
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.GenerateType
	 * @see #setGenerationType(GenerateType)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier_GenerationType()
	 * @model 
	 * @generated
	 */
	GenerateType getGenerationType();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getGenerationType <em>Generation Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Generation Type</em>' attribute.
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.GenerateType
	 * @see #getGenerationType()
	 * @generated
	 */
	void setGenerationType(GenerateType value);

	/**
	 * Returns the value of the '<em><b>Start Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Start Value</em>' attribute.
	 * @see #setStartValue(BigInteger)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier_StartValue()
	 * @model 
	 * @generated
	 */
	BigInteger getStartValue();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getStartValue <em>Start Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Value</em>' attribute.
	 * @see #getStartValue()
	 * @generated
	 */
	void setStartValue(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Increment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Increment</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Increment</em>' attribute.
	 * @see #setIncrement(BigInteger)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier_Increment()
	 * @model 
	 * @generated
	 */
	BigInteger getIncrement();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getIncrement <em>Increment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Increment</em>' attribute.
	 * @see #getIncrement()
	 * @generated
	 */
	void setIncrement(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Minimum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Minimum</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Minimum</em>' attribute.
	 * @see #setMinimum(BigInteger)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier_Minimum()
	 * @model 
	 * @generated
	 */
	BigInteger getMinimum();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getMinimum <em>Minimum</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Minimum</em>' attribute.
	 * @see #getMinimum()
	 * @generated
	 */
	void setMinimum(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Maximum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Maximum</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Maximum</em>' attribute.
	 * @see #setMaximum(BigInteger)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier_Maximum()
	 * @model 
	 * @generated
	 */
	BigInteger getMaximum();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#getMaximum <em>Maximum</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maximum</em>' attribute.
	 * @see #getMaximum()
	 * @generated
	 */
	void setMaximum(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Cycle Option</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Cycle Option</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Cycle Option</em>' attribute.
	 * @see #setCycleOption(boolean)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getIdentitySpecifier_CycleOption()
	 * @model 
	 * @generated
	 */
	boolean isCycleOption();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier#isCycleOption <em>Cycle Option</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cycle Option</em>' attribute.
	 * @see #isCycleOption()
	 * @generated
	 */
	void setCycleOption(boolean value);

} // IdentitySpecifier
