/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Jan 15, 2004
 * 
 * To change the template for this generated file go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.filters.NavigatorExtensionFilter;

/**
 * @author mdelder
 */
public class JarFileFilter extends NavigatorExtensionFilter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.filters.INavigatorExtensionFilter#select(org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorExtensionSite,
	 *      java.lang.Object, java.lang.Object)
	 */
	public boolean select(CommonViewer aViewer, Object aParentElement, Object anElement) {

		if (anElement instanceof JarPackageFragmentRoot)
			return false;
		else if (anElement instanceof IResource)
			return !"jar".equals(((IResource) anElement).getFileExtension()); //$NON-NLS-1$
		return true;
	}

}