package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.IWorkbenchConstants;

public class CommonWorkingSetFactory implements IElementFactory {

	public CommonWorkingSetFactory() {
		super();
		// TODO Auto-generated constructor stub
	}

	 /* (non-Javadoc)
     * @see org.eclipse.ui.IElementFactory
     */
    public IAdaptable createElement(IMemento memento) {
        String workingSetName = memento.getString(IWorkbenchConstants.TAG_NAME);
        String workingSetEditPageId = memento
                .getString(IWorkbenchConstants.TAG_EDIT_PAGE_ID);

        if (workingSetName == null)
            return null;

        CommonWorkingSet workingSet = new CommonWorkingSet(workingSetName, memento);
        if (workingSetEditPageId != null) {
            workingSet.setId(workingSetEditPageId);
        } else {
            // working sets created with builds 20020418 and 20020419 will not
            // have an edit page id. fix this automatically.
            workingSet.setId("org.eclipse.jst.common.CommonWorkingSetPage"); //$NON-NLS-1$
        }
        return workingSet;
    }

}
