/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater implements IWorkingSetUpdater {
	
	public static final String ID= "org.eclipse.jst.common.navigator.ui.OthersWorkingSet";  //$NON-NLS-1$
	
	private IWorkingSet fWorkingSet;
	private WorkingSetModel fWorkingSetModel;
	private boolean disposed = false;
	
	private class ResourceChangeListener implements IResourceChangeListener {
		/*public void resourceChanged(IResourceChangeEvent event) {
			IResourceDelta delta= event.getDelta();
			IResourceDelta[] affectedChildren= delta.getAffectedChildren(IResourceDelta.ADDED | IResourceDelta.REMOVED, IResource.PROJECT);
			if (affectedChildren.length > 0) {
				updateElementsAddedRemoved(fWorkingSetModel.getActiveWorkingSets());
			} else {
				affectedChildren= delta.getAffectedChildren(IResourceDelta.CHANGED, IResource.PROJECT);
				List elements= new ArrayList(Arrays.asList(fWorkingSet.getElements()));
				for (int i= 0; i < affectedChildren.length; i++) {
					IResourceDelta projectDelta= affectedChildren[i];
					IProject project = (IProject)projectDelta.getResource();
					if (elements.contains(project)) {
						updateElements(fWorkingSetModel.getActiveWorkingSets());
						return;
					}
					
				}
			}
		}*/
		public void resourceChanged(IResourceChangeEvent event) {
			if (isDisposed()) return;
			if (fWorkingSetModel == null) return;
			IResourceDelta delta= event.getDelta();
			IResourceDelta[] affectedChildren= delta.getAffectedChildren(IResourceDelta.ADDED | IResourceDelta.REMOVED, IResource.PROJECT);
			if (affectedChildren.length > 0) {
				updateElements(fWorkingSetModel.getActiveWorkingSets());
			} else {
				affectedChildren= delta.getAffectedChildren(IResourceDelta.CHANGED, IResource.PROJECT);
				for (int i= 0; i < affectedChildren.length; i++) {
					IResourceDelta projectDelta= affectedChildren[i];
					if ((projectDelta.getFlags() & IResourceDelta.DESCRIPTION) != 0) {
						updateElements(fWorkingSetModel.getActiveWorkingSets());
						// one is enough
						return;
					}
				}
			}
		}
	}
	private IResourceChangeListener fResourceChangeListener;
	
	private class WorkingSetListener implements IPropertyChangeListener {
		public void propertyChange(PropertyChangeEvent event) {
			if (isDisposed()) return;
			if (fWorkingSetModel == null) return;
			if (IWorkingSetManager.CHANGE_WORKING_SET_CONTENT_CHANGE.equals(event.getProperty())) {
				IWorkingSet changedWorkingSet= (IWorkingSet)event.getNewValue();
				if (changedWorkingSet != fWorkingSet) {
					IWorkingSet[] activeWorkingSets= fWorkingSetModel.getActiveWorkingSets();
					if (contains(activeWorkingSets, changedWorkingSet)
						&& !HistoryWorkingSetUpdater.ID.equals(changedWorkingSet.getId()))
						updateElements(activeWorkingSets);
				}
			}
		}
		private boolean contains(IWorkingSet[] workingSets, IWorkingSet workingSet) {
			for (int i= 0; i < workingSets.length; i++) {
				if (workingSets[i] == workingSet)
					return true;
			}
			return false;
		}
	}
	private IPropertyChangeListener fWorkingSetListener;
	
	/*private class JavaElementChangeListener implements IElementChangedListener {
		public void elementChanged(ElementChangedEvent event) {
			processJavaDelta(new ArrayList(Arrays.asList(fWorkingSet.getElements())), event.getDelta());
		}
		private void processJavaDelta(List elements, IJavaElementDelta delta) {
			IJavaElement jElement= delta.getElement();
			int type= jElement.getElementType();
			if (type == IJavaElement.JAVA_PROJECT) {
				int index= elements.indexOf(jElement);
				int kind= delta.getKind();
				int flags= delta.getFlags();
				if (kind == IJavaElementDelta.CHANGED) {
					if (index != -1 && (flags & IJavaElementDelta.F_CLOSED) != 0) {
						elements.set(index, ((IJavaProject)jElement).getProject());
						fWorkingSet.setElements((IAdaptable[])elements.toArray(new IAdaptable[elements.size()]));
					} else if ((flags & IJavaElementDelta.F_OPENED) != 0) {
						index= elements.indexOf(((IJavaProject)jElement).getProject());
						if (index != -1) {
							elements.set(index, jElement);
							fWorkingSet.setElements((IAdaptable[])elements.toArray(new IAdaptable[elements.size()]));
						}
					}
				}
				// don't visit below projects
				return;
			}
			IJavaElementDelta[] children= delta.getAffectedChildren();
			for (int i= 0; i < children.length; i++) {
				processJavaDelta(elements, children[i]);
			}
		}
	}
	private IElementChangedListener fJavaElementChangeListener;*/
	
	/**
	 * {@inheritDoc}
	 */
	public void add(IWorkingSet workingSet) {
		if (isDisposed()) return;
		Assert.isTrue(fWorkingSet == null);
		fWorkingSet= workingSet;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public boolean remove(IWorkingSet workingSet) {
		if (isDisposed()) return false;
		Assert.isTrue(fWorkingSet == workingSet);
		fWorkingSet= null;
		return true;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public boolean contains(IWorkingSet workingSet) {
		if (isDisposed()) return false;
		return fWorkingSet == workingSet;
	}
	
	public void init(WorkingSetModel model) {
		if (isDisposed()) return;
		fWorkingSetModel= model;
		fResourceChangeListener= new ResourceChangeListener();
		ResourcesPlugin.getWorkspace().addResourceChangeListener(fResourceChangeListener, IResourceChangeEvent.POST_CHANGE);
		fWorkingSetListener= new WorkingSetListener();
		PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(fWorkingSetListener);
		fWorkingSetModel.addPropertyChangeListener(fWorkingSetListener);
		//fJavaElementChangeListener= new JavaElementChangeListener();
		//JavaCore.addElementChangedListener(fJavaElementChangeListener, ElementChangedEvent.POST_CHANGE);
		updateElements(fWorkingSetModel.getActiveWorkingSets());
	}
	
	public void dispose() {
		disposed = true;
		if (fResourceChangeListener != null) {
			ResourcesPlugin.getWorkspace().removeResourceChangeListener(fResourceChangeListener);
			fResourceChangeListener= null;
		}
		if (fWorkingSetListener != null) {
			PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(fWorkingSetListener);
			fWorkingSetListener= null;
		}
		
	}
	
	public void updateElements() {
		if (isDisposed()) return;
		if (fWorkingSetModel == null) return;
		updateElements(fWorkingSetModel.getActiveWorkingSets());
	}
	
	private List getResultantElements(IWorkingSet[] activeWorkingSets) {
		
		List result= new ArrayList();
		Set existingProjects= new HashSet();
		for (int i= 0; i < activeWorkingSets.length; i++) {
			if (activeWorkingSets[i] == fWorkingSet) continue;
			IAdaptable[] elements= activeWorkingSets[i].getElements();
			for (int j= 0; j < elements.length; j++) {
				IAdaptable element= elements[j];
				IResource resource= (IResource)element.getAdapter(IResource.class);
				if (resource != null && resource.getType() == IResource.PROJECT) {
					existingProjects.add(resource);
				}
			}
		}
		
		IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
		for (int i= 0; i < projects.length; i++) {
			if (!existingProjects.contains(projects[i]))
				result.add(projects[i]);
		}
		return result;
	}
	
	private void  updateElementsAddedRemoved(IWorkingSet[] activeWorkingSets) {
		
		boolean diff = false;
		List result = getResultantElements(activeWorkingSets);
		List existingOtherElements= new ArrayList(Arrays.asList(fWorkingSet.getElements()));
		if (existingOtherElements.size() == result.size()) {
			IProject project = null;
			for (int x=0; x< existingOtherElements.size(); ++x) {
				 project = (IProject) existingOtherElements.get(x);
				 if (!result.contains(project)) {
				 	diff = true;
				 }
			}
		} else {
			diff = true;
		}
		if (diff)
		 fWorkingSet.setElements((IAdaptable[])result.toArray(new IAdaptable[result.size()]));
		
	}
	private void updateElements(IWorkingSet[] activeWorkingSets) {
		List result = getResultantElements(activeWorkingSets) ;
		fWorkingSet.setElements((IAdaptable[])result.toArray(new IAdaptable[result.size()]));
	}
	
	private boolean isDisposed() {
		return disposed;
	}
	
	
}