/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.jst.common.navigator.internal.ui.workingsets;


import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.providers.WorkingSetAwareContentProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentProvider;

public class WorkingSetActionProvider implements ICommonActionProvider, IPropertyChangeListener {

	private ViewActionGroup viewActionGroup;
	private WorkingSetActionGroup workingSetActionGroup;
	private WorkingSetAwareContentProvider contentProvider;
	private NavigatorContentService contentService;
	private boolean hasFilledActionBars;
	private StructuredViewer viewer;
	

	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
		contentService = aContentService;
		viewer = aViewer;
		viewActionGroup = new ViewActionGroup(ViewActionGroup.SHOW_WORKING_SETS, this, aViewPart.getSite().getShell());
		workingSetActionGroup = new WorkingSetActionGroup(aViewPart);
		viewActionGroup.setWorkingSetModel(getContentProvider().getWorkingSetModel());
		viewActionGroup.fillFilters(viewer);
	}

	public void dispose() {
		viewActionGroup.dispose();
		workingSetActionGroup.dispose();

	}

	public void setActionContext(ActionContext aContext) {
		viewActionGroup.setContext(aContext);
		workingSetActionGroup.setContext(aContext);
	}

	public boolean fillContextMenu(IMenuManager aMenu) {
		viewActionGroup.fillContextMenu(aMenu);
		workingSetActionGroup.fillContextMenu(aMenu);
		return true;
	}
	
	public boolean fillActionBars(IActionBars theActionBars) {
		if (!hasFilledActionBars) {
			viewActionGroup.fillActionBars(theActionBars);
			workingSetActionGroup.fillActionBars(theActionBars);
			return (hasFilledActionBars = true);
		}
		return false;
	}

	public void restoreState(IMemento aMemento) {
		getContentProvider().restoreState(aMemento);
		viewActionGroup.restoreState(aMemento);
		if (viewer != null) {
			viewer.refresh();
		}
		
	}
	
	

	public void saveState(IMemento aMemento) {
		getContentProvider().saveState(aMemento);
		viewActionGroup.saveState(aMemento);
		
	}

	public void propertyChange(PropertyChangeEvent event) {
		getContentProvider().workingSetModelChanged(event);
		if (ViewActionGroup.MODE_CHANGED.equals(event.getProperty())) {
			viewActionGroup.fillFilters(viewer);
		}
	}


	private WorkingSetAwareContentProvider getContentProvider() {
		if (contentProvider == null) {
			NavigatorContentDescriptor groupDescriptor = NavigatorContentDescriptorRegistry.getInstance().getContentDescriptor(WorkingSetAwareContentProvider.CONTENT_EXTENSION_ID);
			if (groupDescriptor != null) {
				NavigatorContentProvider delegateContentProvider = (NavigatorContentProvider) contentService.getDescriptorInstance(groupDescriptor).getContentProvider();
				contentProvider = (WorkingSetAwareContentProvider) delegateContentProvider.getDelegateContentProvider();
			}
		}
		return contentProvider;
	}


}
