/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.workbench;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterProvider;

/**
 * @author mdelder
 *  
 */
public class ResourceExtensionFilterProvider implements ExtensionFilterProvider {

	private static final String HIDE = "Hides " ;
	/**
	 *  
	 */
	public ResourceExtensionFilterProvider() {
		super();
	}

	/*
	 * (non-Javadoc) @return a List of ExtensionFilterDescriptor (s)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.filters.ExtensionFilterProvider#getExtensionFilterDescriptors(java.lang.String)
	 */
	public List getExtensionFilterDescriptors(String extensionId, String viewerId) {
		List extFilterDescriptors = new ArrayList();
		ExtensionFilterDescriptor extFilterDescriptor = null;
		ViewerFilter vf = null;

		AbstractUIPlugin plugin = (AbstractUIPlugin) Platform.getPlugin(IDEWorkbenchPlugin.IDE_WORKBENCH);
		if (plugin != null) {
			IExtensionPoint extension = plugin.getDescriptor().getExtensionPoint("resourceFilters"); //$NON-NLS-1$
			if (extension != null) {
				IExtension[] extensions = extension.getExtensions();
				for (int i = 0; i < extensions.length; i++) {
					IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
					for (int j = 0; j < configElements.length; j++) {
						String pattern = configElements[j].getAttribute("pattern");//$NON-NLS-1$
						if (pattern != null) {
							vf = new ResourcePatternFilter();
							((ResourcePatternFilter) vf).setPatterns(new String[]{pattern});
							String selected = configElements[j].getAttribute("selected");//$NON-NLS-1$

							// override the enablement of .* or use the Resource setting
							boolean isDotStar = (pattern != null && ".*".equals(pattern)); //$NON-NLS-1$
							boolean enabledByDefault = (isDotStar || (selected != null && selected.equalsIgnoreCase("true"))); //$NON-NLS-1$ 
							String description = HIDE + pattern;
							extFilterDescriptor = new ExtensionFilterDescriptor(extensionId + "." + pattern, extensionId, //$NON-NLS-1$
										pattern, description, viewerId, enabledByDefault, vf);

							if (!extFilterDescriptors.contains(extFilterDescriptor))
								extFilterDescriptors.add(extFilterDescriptor);
						}
					}
				}
			}
		}


		//		  if (pattensDefined.size() > 0) {
		//		  	NamePatternFilter patternFilter = new NamePatternFilter();
		//		  	patternFilter.setPatterns(patternsDefined);
		//		  	extFilterDescriptor = new ExtensionFilterDescriptor(descriptors[i].getId(), extensionId,
		// descriptors[i].getName(), descriptors[i].getDescription(), viewerId, false, vf);
		//		  	extFilterDescriptors.add(extFilterDescriptor);
		//		  }

		return extFilterDescriptors;
	}
}