/**
 * <copyright>
 * </copyright>
 *
 * $Id: DistinctUserDefinedTypeItemProvider.java,v 1.2 2005/06/15 18:16:14 ledunnel Exp $
 */
package org.eclipse.wst.rdb.internal.models.sql.datatypes.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.wst.rdb.internal.models.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataTypesFactory;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataTypesPackage;

import org.eclipse.wst.rdb.internal.models.sql.schema.provider.SqlmodelEditPlugin;

/**
 * This is the item provider adpater for a {@link org.eclipse.wst.rdb.internal.models.sql.datatypes.DistinctUserDefinedType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DistinctUserDefinedTypeItemProvider
	extends UserDefinedTypeItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DistinctUserDefinedTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addPredefinedRepresentationPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Predefined Representation feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addPredefinedRepresentationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_DistinctUserDefinedType_predefinedRepresentation_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_DistinctUserDefinedType_predefinedRepresentation_feature", "_UI_DistinctUserDefinedType_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 true));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation());
		}
		return childrenFeatures;
	}

	/**
	 * This returns DistinctUserDefinedType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return getResourceLocator().getImage("full/obj16/DistinctUserDefinedType"); //$NON-NLS-1$
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((DistinctUserDefinedType)object).getName();
		return label == null || label.length() == 0 ?
			getString("_UI_DistinctUserDefinedType_type") : //$NON-NLS-1$
			getString("_UI_DistinctUserDefinedType_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createBooleanDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createIntervalDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createBinaryStringDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createTimeDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createDataLinkDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createDateDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createIntegerDataType()));

		newChildDescriptors.add
			(createChildParameter
				(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType_PredefinedRepresentation(),
				 SQLDataTypesFactory.eINSTANCE.createXMLDataType()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return SqlmodelEditPlugin.INSTANCE;
	}

}
