/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.common.navigator.internal.groups;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorGroupLabelProvider extends LabelProvider implements ILabelProvider {

	private WorkbenchLabelProvider delegateProvider = new WorkbenchLabelProvider();

	public Image getImage(Object element) {
		if (element instanceof NavigatorGroup)
			return retrieveAndStoreImage((NavigatorGroup) element);
		else if (element instanceof IProject)
			return delegateProvider.getImage(element);
		else
			return null;
	}

	public String getText(Object element) {
		if (element instanceof NavigatorGroup)
			return ((NavigatorGroup) element).getDisplayName();
		else if (element instanceof IProject)
			return delegateProvider.getText(element);
		else
			return null;
	}

	private Image retrieveAndStoreImage(NavigatorGroup group) {
		ImageRegistry imageRegistry = getImageRegistry(group.getPluginID());
		if (imageRegistry == null)
			return null; //no image.
		String icon = group.getIcon();
		Image image = imageRegistry.get(icon);
		if (image == null || image.isDisposed()) {
			ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin(group.getPluginID(), icon);
			if (descriptor != null) {
				image = descriptor.createImage();
				if (image != null) {
					imageRegistry.put(icon, image);
				}
			}
		}
		return image;
	}

	/**
	 * @param pluginID
	 * @return
	 */
	private ImageRegistry getImageRegistry(String pluginID) {
		if (pluginID != null) {
			IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor(pluginID);
			if (desc != null) {
				Plugin plugin;
				try {
					plugin = desc.getPlugin();
				} catch (CoreException e) {
					return null;
				}
				if (plugin instanceof AbstractUIPlugin) {
					return ((AbstractUIPlugin) plugin).getImageRegistry();
				}
			}
		}
		return null;
	}
}