/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.workbench;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;

/**
 * This class adds marker images to workspace projects.
 * <p>
 * This class is experimental and is subject to change.
 * </p>
 */
public class ProjectDecorator implements ILightweightLabelDecorator {
	private static ImageDescriptor ERROR;
	private static ImageDescriptor WARNING;

	static {
		String iconPath = "icons/full/ovr16/error_co.gif"; //$NON-NLS-1$
		try {
			Plugin plugin = WorkbenchNavigatorPlugin.getDefault(); //$NON-NLS-1$
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath);
			ERROR = ImageDescriptor.createFromURL(url);
		} catch (Exception e) {
			// Should not happen
		}
		iconPath = "icons/full/ovr16/warning_co.gif"; //$NON-NLS-1$
		try {
			Plugin plugin = WorkbenchNavigatorPlugin.getDefault(); //$NON-NLS-1$
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath);
			WARNING = ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
			// Should not happen
		}
	}

	/**
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		//do nothing
	}

	/**
	 * Overlay the decoration with an image relating to the state of the provided object.
	 */
	public void decorate(Object element, IDecoration decoration) {
		if (element instanceof IProject == false)
			return;
		IProject project = (IProject) element;
		ImageDescriptor overlay = null;
		try {
			IMarker[] markers = project.findMarkers(IMarker.PROBLEM, true, IResource.DEPTH_INFINITE);
			// need to distinguish between errors and warnings
			if (markers.length > 0) {
				overlay = WARNING;
				for (int i = 0; i < markers.length; i++) {
					IMarker marker = markers[i];
					int severity = marker.getAttribute(IMarker.SEVERITY, -1);
					if (severity == IMarker.SEVERITY_ERROR) {
						overlay = ERROR;
						break;
					}
				}
			}
		} catch (CoreException e) {
			//Ignore
		}
		if (overlay != null) {
			decoration.addOverlay(overlay);
		}
	}

	/**
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		// no resources to dispose
	}

	/**
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object,
	 *      java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/**
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		//do nothing
	}
}