/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.wst.internet.internal.proxy;

import org.eclipse.core.runtime.IStatus;

/**
* This class provides logging facilities for the
* <code>org.eclipse.wst.internet.internal.proxy</code> plugin.
*/
public class Log
{
  private static String pluginId_;

  /**
  * The line separator for the current operating system.
  */
  public static final String LINE_SEPARATOR = System.getProperty("line.separator");

  /**
  * Use this severity to log any event associated with
  * a task that has succeeded.
  */
  public static final int OK = 0;

  /**
  * Use this severity to log any event associated with
  * a task that has succeeded but with information the
  * user may find useful.
  */
  public static final int INFO = 1;

  /**
  * Use this severity to log any event associated with
  * a task that has succeeded but with side effects
  * that may surprise the user.
  */
  public static final int WARNING = 2;

  /**
  * Use this severity to log any event associated with
  * a task that has failed.
  */
  public static final int ERROR = 4;

  //
  // Not constructable.
  //
  private Log ()
  {
  }

  /**
  * Initializes the Log class for use.
  * @param pluginId The plugin ID.
  */
  static void init ( String pluginId )
  {
    pluginId_ = pluginId;
  }

  /**
  * Writes a message to the log file.
  * @param obj The object (ie. <code>this</code>) writing the log entry.
  * @param method The name of the method writing the log entry.
  * @param severity The severity, one of
  * {@link #OK OK},
  * {@link #INFO INFO},
  * {@link #WARNING WARNING} or
  * {@link #ERROR ERROR}.
  * @param msg The message.
  */
  public static void write ( Object obj, String method, int severity, String msg )
  {
  }

  /**
  * Writes an exception object to the log file.
  * @param obj The object (ie. <code>this</code>) writing the log entry.
  * @param method The name of the method writing the log entry.
  * @param severity The severity, one of
  * {@link #OK OK},
  * {@link #INFO INFO},
  * {@link #WARNING WARNING} or
  * {@link #ERROR ERROR}.
  * @param msg The exception.
  */
  public static void write ( Object obj, String method, int severity, Throwable msg )
  {
  }

  /**
  * Writes a status object to the log file.
  * @param obj The object (ie. <code>this</code>) writing the log entry.
  * @param method The name of the method writing the log entry.
  * @param severity The severity, one of
  * {@link #OK OK},
  * {@link #INFO INFO},
  * {@link #WARNING WARNING} or
  * {@link #ERROR ERROR}.
  * @param msg The status object.
  */
  public static void write ( Object obj, String method, IStatus msg )
  {
  }
}
