/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.filter;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.rdb.connection.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ISchemaNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ISequenceNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IStoredProcedureNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ITableNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IUDFNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IUDTNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IViewNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;

/**
 * @author ledunnel
 */
public class FilterWizard extends Wizard implements INewWizard {
	private ISelection selection;

	private FilterWizardPage page;

	public FilterWizard(ISelection sel) {
		super();
		selection = sel;
	}

	public void addPages() {
		super.addPages();
		page = new FilterWizardPage(
				"org.eclipse.wst.rdb.server.internal.ui.explorer.filter", //$NON-NLS-1$
				ResourceLoader.INSTANCE.queryString("_UI_TITLE_FILTER"), ImageDescription.getFilterWizardDescriptor(), //$NON-NLS-1$
				selection);
		addPage(page);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {
		Object sel = ((StructuredSelection) selection).getFirstElement();
		ConnectionInfo connInfo = null;
		if (sel instanceof ISchemaNode) {
			connInfo = RDBCorePlugin.getDefault().getConnectionManager()
					.getConnectionInfo(
							(SQLObject) ((IVirtualNode) sel).getParent());
			if (!page.isFilterSpecified()) {
				connInfo.removeFilter(ConnectionFilter.SCHEMA_FILTER);
				((ICatalogObject) ((IVirtualNode) sel).getParent()).refresh();
			} else {
				ConnectionFilter connFilter = new ConnectionFilterImpl();
				connFilter.setPredicate(page.getPredicate());
				connInfo.addFilter(ConnectionFilter.SCHEMA_FILTER, connFilter);
				((ICatalogObject) ((IVirtualNode) sel).getParent()).refresh();
			}
		} else if (sel instanceof IVirtualNode) {
			Schema schema = (Schema) ((IVirtualNode) sel).getParent();
			connInfo = RDBCorePlugin.getDefault().getConnectionManager()
					.getConnectionInfo((SQLObject) schema.getDatabase());

			String connectionFilterType = ConnectionFilter.TABLE_FILTER;
			if (sel instanceof ITableNode) {
				connectionFilterType = ConnectionFilter.TABLE_FILTER;
			} else if (sel instanceof IViewNode) {
				connectionFilterType = ConnectionFilter.VIEW_FILTER;
			} else if (sel instanceof IStoredProcedureNode) {
				connectionFilterType = ConnectionFilter.STORED_PROCEDURE_FILTER;
			} else if (sel instanceof IUDFNode) {
				connectionFilterType = ConnectionFilter.USER_DEFINED_FUNCTION_FILTER;
			} else if (sel instanceof ISequenceNode) {
				connectionFilterType = ConnectionFilter.SEQUENCE_FILTER;
			} else if (sel instanceof IUDTNode) {
				connectionFilterType = ConnectionFilter.USER_DEFINED_TYPE_FILTER;
			}

			if (!page.isFilterSpecified()) {
				connInfo.removeFilter(schema.getName() + "::" //$NON-NLS-1$
						+ connectionFilterType);
				((ICatalogObject) schema).refresh();
			} else {
				ConnectionFilter connFilter = new ConnectionFilterImpl();
				connFilter.setPredicate(page.getPredicate());
				connInfo.addFilter(schema.getName() + "::" //$NON-NLS-1$
						+ connectionFilterType, connFilter);
				((ICatalogObject) schema).refresh();
			}
		}

//		// For testing purposes only{
//		if (connInfo != null) {
//			Iterator filters = connInfo.getFilters();
//			while (filters.hasNext()) {
//				ConnectionFilter connFilter = (ConnectionFilter) filters.next();
//				System.out.println(connFilter.getPredicate());
//				System.out.println(connFilter.getOperator());
//				System.out.println(connFilter.getPattern());
//				
//				String[] elements = connFilter.getPatternElements();
//				for (int index = 0; index < elements.length;index++) {
//				    System.out.println(elements[index]);
//				}
//			}
//		}

		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench,
	 *      org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {

	}

	public void createPageControls(Composite pageContainer) {
		super.createPageControls(pageContainer);
	}
}