/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards.shared;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ImagePath;

/**
 * @author ljulien
 */
public class UserIdentification extends Dialog
{
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final String HEADER_TITLE = resourceLoader.queryString("CUI_USER_IDENT_DIALOG_TITLE"); //$NON-NLS-1$
    private static final String USER_NAME = resourceLoader.queryString("CUI_USER_IDENT_DIALOG_USERID_LBL"); //$NON-NLS-1$
    private static final String PASSWORD = resourceLoader.queryString("CUI_USER_IDENT_DIALOG_PASSWORD_LBL"); //$NON-NLS-1$
    
    private static final String BLANK = ""; //$NON-NLS-1$
    
    private Text message;
    private Text userName;
    private Text password;
    
    private String messageText;
    private String userNameText;
    private String passwordText;

    /**
     * @param composite -
     *            The Composite to add the UserName and Passord controls on
     */
    protected void createMessage(Composite parentComposite)
    {
        if (messageText != null && messageText.length() > 0)
        {
            message = new Text(parentComposite, SWT.READ_ONLY | SWT.MULTI | SWT.WRAP);
            Display display = parentComposite.getDisplay();
            Color background = JFaceColors.getErrorBackground(display);
            Color foreground = JFaceColors.getErrorText(display);
            JFaceColors.setColors(message, foreground, background);
            message.setFont(JFaceResources.getDialogFont());
            message.setText(messageText);
            GridData gd = new GridData(GridData.FILL_HORIZONTAL);
            GC gc = new GC(message);
            Point e = gc.textExtent(messageText);
            gd.heightHint = e.y * 3;
            message.setLayoutData(gd);
        }
    }

    /**
     * @param composite -
     *            The Composite to add the UserName and Passord controls on
     */
    protected void createUserPasswordInformation(Composite parentComposite)
    {
        Composite composite = new Composite(parentComposite, SWT.NONE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        Label label = new Label(composite, SWT.NONE);
        label.setText(USER_NAME);
        userName = new Text(composite, SWT.SINGLE | SWT.BORDER);
        userName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        if (userNameText != null)
        {
            userName.setText(userNameText);
        }
        userName.addModifyListener(new ModifyListener()
        {
            public void modifyText(ModifyEvent e)
            {
                userNameText = userName.getText();
            }
        });
        label = new Label(composite, SWT.NONE);
        label.setText(PASSWORD);
        password = new Text(composite, SWT.SINGLE | SWT.BORDER);
        password.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        password.setEchoChar('*');
        password.addModifyListener(new ModifyListener()
        {
            public void modifyText(ModifyEvent e)
            {
                passwordText = password.getText();
            }
        });
        
        if (userNameText != null && !userNameText.equals(BLANK))
        {
            password.forceFocus();
        }
    }

    /**
     * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
     */
    protected void configureShell(Shell shell)
    {
        super.configureShell(shell);
        shell.setText(HEADER_TITLE);
        // We need to load an image from the core.ui package.  Unfortunately the 
        // resource loader class in that package has the same name as the one in this
        // class, so we have to fully qualify the package name.
        org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader coreResLoader =
            org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader.getResourceLoader();
        shell.setImage(coreResLoader.queryImageFromRegistry(ImagePath.ADD_SERVER_CONNECTION));
    }

    /**
     * Provides the controls for this main area of the dialog.
     * 
     * @param parent
     *            The parent composite.
     */
    protected Control createDialogArea(Composite parent)
    {
        Composite parentComposite = createDialogComposite(parent);
        GridData data = new GridData(GridData.FILL_BOTH);
        data.widthHint = 250;
        parentComposite.setLayoutData(data);
        if (messageText != null)
            createMessage(parentComposite);
        createUserPasswordInformation(parentComposite);
        return parentComposite;
    }

    /**
     * Creates and lays out a composite for the dialog area. This uses a default
     * GridLayout (one column), so children must set their own GridData objects
     * and have their own layouts if they arrange in more than one column.
     * 
     * @param parent
     *            The parent composite.
     * @return A composite to contain the children in the dialog area.
     */
    protected Composite createDialogComposite(Composite parent)
    {
        Composite parentComposite = new Composite(parent, SWT.NONE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
        gridLayout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
        gridLayout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
        gridLayout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
        parentComposite.setLayout(gridLayout);
        return parentComposite;
    }

    /**
     * Constructs a user ID and password prompt with an initial user ID.
     * 
     * @param userNameText
     *            An initial user ID.
     */
    public UserIdentification(String userNameText)
    {
        this(userNameText, null);
    }

    /**
     * Constructs a user ID and password prompt with an initial user ID and
     * message.
     * 
     * @param userNameText
     *            An initial user ID.
     * @param message
     *            A message to display at the top of the prompt, or null. If
     *            null, no message appears.
     */
    public UserIdentification(String userNameText, String message)
    {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL | SWT.RESIZE);
        this.userNameText = userNameText;
        this.messageText = message;
    }

    /**
     * @return The userName entered by the user
     */
    public String getUserNameInformation()
    {
        return this.userNameText;
    }

    /**
     * @return The password entered by the user
     */
    public String getPasswordInformation()
    {
        return this.passwordText;
    }
}