/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.constraints.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.wst.rdb.internal.models.sql.constraints.IncrementType;
import org.eclipse.wst.rdb.internal.models.sql.constraints.IndexMember;
import org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SQLObjectImpl;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Index Member</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.constraints.impl.IndexMemberImpl#getIncrementType <em>Increment Type</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.constraints.impl.IndexMemberImpl#getColumn <em>Column</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IndexMemberImpl extends SQLObjectImpl implements IndexMember {
	/**
	 * The default value of the '{@link #getIncrementType() <em>Increment Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncrementType()
	 * @generated
	 * @ordered
	 */
	protected static final IncrementType INCREMENT_TYPE_EDEFAULT = IncrementType.ASC_LITERAL;

	/**
	 * The cached value of the '{@link #getIncrementType() <em>Increment Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncrementType()
	 * @generated
	 * @ordered
	 */
	protected IncrementType incrementType = INCREMENT_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getColumn() <em>Column</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumn()
	 * @generated
	 * @ordered
	 */
	protected Column column = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IndexMemberImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SQLConstraintsPackage.eINSTANCE.getIndexMember();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IncrementType getIncrementType() {
		return incrementType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncrementType(IncrementType newIncrementType) {
		IncrementType oldIncrementType = incrementType;
		incrementType = newIncrementType == null ? INCREMENT_TYPE_EDEFAULT : newIncrementType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLConstraintsPackage.INDEX_MEMBER__INCREMENT_TYPE, oldIncrementType, incrementType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Column getColumn() {
		if (column != null && column.eIsProxy()) {
			Column oldColumn = column;
			column = (Column)eResolveProxy((InternalEObject)column);
			if (column != oldColumn) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SQLConstraintsPackage.INDEX_MEMBER__COLUMN, oldColumn, column));
			}
		}
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Column basicGetColumn() {
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumn(Column newColumn) {
		Column oldColumn = column;
		column = newColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLConstraintsPackage.INDEX_MEMBER__COLUMN, oldColumn, column));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLConstraintsPackage.INDEX_MEMBER__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLConstraintsPackage.INDEX_MEMBER__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicRemove(otherEnd, msgs);
				case SQLConstraintsPackage.INDEX_MEMBER__DEPENDENCIES:
					return ((InternalEList)getDependencies()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLConstraintsPackage.INDEX_MEMBER__EANNOTATIONS:
				return getEAnnotations();
			case SQLConstraintsPackage.INDEX_MEMBER__NAME:
				return getName();
			case SQLConstraintsPackage.INDEX_MEMBER__DEPENDENCIES:
				return getDependencies();
			case SQLConstraintsPackage.INDEX_MEMBER__DESCRIPTION:
				return getDescription();
			case SQLConstraintsPackage.INDEX_MEMBER__LABEL:
				return getLabel();
			case SQLConstraintsPackage.INDEX_MEMBER__INCREMENT_TYPE:
				return getIncrementType();
			case SQLConstraintsPackage.INDEX_MEMBER__COLUMN:
				if (resolve) return getColumn();
				return basicGetColumn();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLConstraintsPackage.INDEX_MEMBER__EANNOTATIONS:
				getEAnnotations().clear();
				getEAnnotations().addAll((Collection)newValue);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__NAME:
				setName((String)newValue);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__DEPENDENCIES:
				getDependencies().clear();
				getDependencies().addAll((Collection)newValue);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__LABEL:
				setLabel((String)newValue);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__INCREMENT_TYPE:
				setIncrementType((IncrementType)newValue);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__COLUMN:
				setColumn((Column)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLConstraintsPackage.INDEX_MEMBER__EANNOTATIONS:
				getEAnnotations().clear();
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__DEPENDENCIES:
				getDependencies().clear();
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__INCREMENT_TYPE:
				setIncrementType(INCREMENT_TYPE_EDEFAULT);
				return;
			case SQLConstraintsPackage.INDEX_MEMBER__COLUMN:
				setColumn((Column)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLConstraintsPackage.INDEX_MEMBER__EANNOTATIONS:
				return eAnnotations != null && !eAnnotations.isEmpty();
			case SQLConstraintsPackage.INDEX_MEMBER__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SQLConstraintsPackage.INDEX_MEMBER__DEPENDENCIES:
				return dependencies != null && !dependencies.isEmpty();
			case SQLConstraintsPackage.INDEX_MEMBER__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case SQLConstraintsPackage.INDEX_MEMBER__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case SQLConstraintsPackage.INDEX_MEMBER__INCREMENT_TYPE:
				return incrementType != INCREMENT_TYPE_EDEFAULT;
			case SQLConstraintsPackage.INDEX_MEMBER__COLUMN:
				return column != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (incrementType: "); //$NON-NLS-1$
		result.append(incrementType);
		result.append(')');
		return result.toString();
	}

} //IndexMemberImpl
