/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.datatypes.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.IntervalDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.IntervalQualifierType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PrimitiveType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataTypesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interval Data Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.datatypes.impl.IntervalDataTypeImpl#getLeadingQualifier <em>Leading Qualifier</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.datatypes.impl.IntervalDataTypeImpl#getTrailingQualifier <em>Trailing Qualifier</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.datatypes.impl.IntervalDataTypeImpl#getLeadingFieldPrecision <em>Leading Field Precision</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.datatypes.impl.IntervalDataTypeImpl#getTrailingFieldPrecision <em>Trailing Field Precision</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.datatypes.impl.IntervalDataTypeImpl#getFractionalSecondsPrecision <em>Fractional Seconds Precision</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntervalDataTypeImpl extends PredefinedDataTypeImpl implements IntervalDataType {
	/**
	 * The default value of the '{@link #getLeadingQualifier() <em>Leading Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeadingQualifier()
	 * @generated
	 * @ordered
	 */
	protected static final IntervalQualifierType LEADING_QUALIFIER_EDEFAULT = IntervalQualifierType.YEAR_LITERAL;

	/**
	 * The cached value of the '{@link #getLeadingQualifier() <em>Leading Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeadingQualifier()
	 * @generated
	 * @ordered
	 */
	protected IntervalQualifierType leadingQualifier = LEADING_QUALIFIER_EDEFAULT;

	/**
	 * The default value of the '{@link #getTrailingQualifier() <em>Trailing Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTrailingQualifier()
	 * @generated
	 * @ordered
	 */
	protected static final IntervalQualifierType TRAILING_QUALIFIER_EDEFAULT = IntervalQualifierType.YEAR_LITERAL;

	/**
	 * The cached value of the '{@link #getTrailingQualifier() <em>Trailing Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTrailingQualifier()
	 * @generated
	 * @ordered
	 */
	protected IntervalQualifierType trailingQualifier = TRAILING_QUALIFIER_EDEFAULT;

	/**
	 * The default value of the '{@link #getLeadingFieldPrecision() <em>Leading Field Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeadingFieldPrecision()
	 * @generated
	 * @ordered
	 */
	protected static final int LEADING_FIELD_PRECISION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLeadingFieldPrecision() <em>Leading Field Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeadingFieldPrecision()
	 * @generated
	 * @ordered
	 */
	protected int leadingFieldPrecision = LEADING_FIELD_PRECISION_EDEFAULT;

	/**
	 * The default value of the '{@link #getTrailingFieldPrecision() <em>Trailing Field Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTrailingFieldPrecision()
	 * @generated
	 * @ordered
	 */
	protected static final int TRAILING_FIELD_PRECISION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTrailingFieldPrecision() <em>Trailing Field Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTrailingFieldPrecision()
	 * @generated
	 * @ordered
	 */
	protected int trailingFieldPrecision = TRAILING_FIELD_PRECISION_EDEFAULT;

	/**
	 * The default value of the '{@link #getFractionalSecondsPrecision() <em>Fractional Seconds Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFractionalSecondsPrecision()
	 * @generated
	 * @ordered
	 */
	protected static final int FRACTIONAL_SECONDS_PRECISION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getFractionalSecondsPrecision() <em>Fractional Seconds Precision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFractionalSecondsPrecision()
	 * @generated
	 * @ordered
	 */
	protected int fractionalSecondsPrecision = FRACTIONAL_SECONDS_PRECISION_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntervalDataTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SQLDataTypesPackage.eINSTANCE.getIntervalDataType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntervalQualifierType getLeadingQualifier() {
		return leadingQualifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLeadingQualifier(IntervalQualifierType newLeadingQualifier) {
		IntervalQualifierType oldLeadingQualifier = leadingQualifier;
		leadingQualifier = newLeadingQualifier == null ? LEADING_QUALIFIER_EDEFAULT : newLeadingQualifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_QUALIFIER, oldLeadingQualifier, leadingQualifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntervalQualifierType getTrailingQualifier() {
		return trailingQualifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTrailingQualifier(IntervalQualifierType newTrailingQualifier) {
		IntervalQualifierType oldTrailingQualifier = trailingQualifier;
		trailingQualifier = newTrailingQualifier == null ? TRAILING_QUALIFIER_EDEFAULT : newTrailingQualifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_QUALIFIER, oldTrailingQualifier, trailingQualifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLeadingFieldPrecision() {
		return leadingFieldPrecision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLeadingFieldPrecision(int newLeadingFieldPrecision) {
		int oldLeadingFieldPrecision = leadingFieldPrecision;
		leadingFieldPrecision = newLeadingFieldPrecision;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_FIELD_PRECISION, oldLeadingFieldPrecision, leadingFieldPrecision));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTrailingFieldPrecision() {
		return trailingFieldPrecision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTrailingFieldPrecision(int newTrailingFieldPrecision) {
		int oldTrailingFieldPrecision = trailingFieldPrecision;
		trailingFieldPrecision = newTrailingFieldPrecision;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_FIELD_PRECISION, oldTrailingFieldPrecision, trailingFieldPrecision));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getFractionalSecondsPrecision() {
		return fractionalSecondsPrecision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFractionalSecondsPrecision(int newFractionalSecondsPrecision) {
		int oldFractionalSecondsPrecision = fractionalSecondsPrecision;
		fractionalSecondsPrecision = newFractionalSecondsPrecision;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLDataTypesPackage.INTERVAL_DATA_TYPE__FRACTIONAL_SECONDS_PRECISION, oldFractionalSecondsPrecision, fractionalSecondsPrecision));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLDataTypesPackage.INTERVAL_DATA_TYPE__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLDataTypesPackage.INTERVAL_DATA_TYPE__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicRemove(otherEnd, msgs);
				case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DEPENDENCIES:
					return ((InternalEList)getDependencies()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__EANNOTATIONS:
				return getEAnnotations();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__NAME:
				return getName();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DEPENDENCIES:
				return getDependencies();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DESCRIPTION:
				return getDescription();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LABEL:
				return getLabel();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__PRIMITIVE_TYPE:
				return getPrimitiveType();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_QUALIFIER:
				return getLeadingQualifier();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_QUALIFIER:
				return getTrailingQualifier();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_FIELD_PRECISION:
				return new Integer(getLeadingFieldPrecision());
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_FIELD_PRECISION:
				return new Integer(getTrailingFieldPrecision());
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__FRACTIONAL_SECONDS_PRECISION:
				return new Integer(getFractionalSecondsPrecision());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__EANNOTATIONS:
				getEAnnotations().clear();
				getEAnnotations().addAll((Collection)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__NAME:
				setName((String)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DEPENDENCIES:
				getDependencies().clear();
				getDependencies().addAll((Collection)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LABEL:
				setLabel((String)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__PRIMITIVE_TYPE:
				setPrimitiveType((PrimitiveType)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_QUALIFIER:
				setLeadingQualifier((IntervalQualifierType)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_QUALIFIER:
				setTrailingQualifier((IntervalQualifierType)newValue);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_FIELD_PRECISION:
				setLeadingFieldPrecision(((Integer)newValue).intValue());
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_FIELD_PRECISION:
				setTrailingFieldPrecision(((Integer)newValue).intValue());
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__FRACTIONAL_SECONDS_PRECISION:
				setFractionalSecondsPrecision(((Integer)newValue).intValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__EANNOTATIONS:
				getEAnnotations().clear();
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DEPENDENCIES:
				getDependencies().clear();
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__PRIMITIVE_TYPE:
				setPrimitiveType(PRIMITIVE_TYPE_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_QUALIFIER:
				setLeadingQualifier(LEADING_QUALIFIER_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_QUALIFIER:
				setTrailingQualifier(TRAILING_QUALIFIER_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_FIELD_PRECISION:
				setLeadingFieldPrecision(LEADING_FIELD_PRECISION_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_FIELD_PRECISION:
				setTrailingFieldPrecision(TRAILING_FIELD_PRECISION_EDEFAULT);
				return;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__FRACTIONAL_SECONDS_PRECISION:
				setFractionalSecondsPrecision(FRACTIONAL_SECONDS_PRECISION_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__EANNOTATIONS:
				return eAnnotations != null && !eAnnotations.isEmpty();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DEPENDENCIES:
				return dependencies != null && !dependencies.isEmpty();
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__PRIMITIVE_TYPE:
				return primitiveType != PRIMITIVE_TYPE_EDEFAULT;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_QUALIFIER:
				return leadingQualifier != LEADING_QUALIFIER_EDEFAULT;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_QUALIFIER:
				return trailingQualifier != TRAILING_QUALIFIER_EDEFAULT;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__LEADING_FIELD_PRECISION:
				return leadingFieldPrecision != LEADING_FIELD_PRECISION_EDEFAULT;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__TRAILING_FIELD_PRECISION:
				return trailingFieldPrecision != TRAILING_FIELD_PRECISION_EDEFAULT;
			case SQLDataTypesPackage.INTERVAL_DATA_TYPE__FRACTIONAL_SECONDS_PRECISION:
				return fractionalSecondsPrecision != FRACTIONAL_SECONDS_PRECISION_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (leadingQualifier: "); //$NON-NLS-1$
		result.append(leadingQualifier);
		result.append(", trailingQualifier: "); //$NON-NLS-1$
		result.append(trailingQualifier);
		result.append(", leadingFieldPrecision: "); //$NON-NLS-1$
		result.append(leadingFieldPrecision);
		result.append(", trailingFieldPrecision: "); //$NON-NLS-1$
		result.append(trailingFieldPrecision);
		result.append(", fractionalSecondsPrecision: "); //$NON-NLS-1$
		result.append(fractionalSecondsPrecision);
		result.append(')');
		return result.toString();
	}

} //IntervalDataTypeImpl
