/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.rte.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import java.util.StringTokenizer;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.DatabaseImpl;

import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;



public class JDBCDatabase extends DatabaseImpl implements ICatalogObject {
	public JDBCDatabase(Connection connection) {
		if(connection == null) {
			System.err.println("null connection"); //$NON-NLS-1$
			throw new RuntimeException();
		}
		this.connection = connection;
	}

	public synchronized void refresh() {
		if(this.schemasLoaded) {
			this.schemasLoaded = false;
			this.schemas.clear();
		}
		
		RefreshManager.getInstance().referesh(this);
		
	}

	public EList getSchemas() {
		if(!this.schemasLoaded) this.loadSchemas();
		return this.schemas;
	}
	
	
	public boolean isSystemObject() {
		return false;
	}

	public Connection getConnection() {
		return this.connection;
	}
	
	public Database getCatalogDatabase() {
		return this;		
	}
	
	public boolean eIsSet(EStructuralFeature eFeature) {
		int id = eDerivedStructuralFeatureID(eFeature);
		if(id == SQLSchemaPackage.DATABASE__SCHEMAS) {
			this.getSchemas();
		}
		return super.eIsSet(eFeature);
	}	

	private synchronized void loadSchemas() {
		if(this.schemasLoaded) return;
		EList schemaList = super.getSchemas();
		boolean deliver = this.eDeliver();
		this.eSetDeliver(false);	
		try {
			ConnectionInfo connectionInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo(this);
			ConnectionFilter filter = connectionInfo.getFilter(this.getName()+"::"+ConnectionFilter.SCHEMA_FILTER); //$NON-NLS-1$
			if (filter == null) {  //if schema filter is null, then get default filter
				filter = connectionInfo.getFilter(ConnectionFilter.SCHEMA_FILTER);
			}
			String[] schemaAry = null;
			String pattern = null;
			if (filter != null) {
				String schemaFilter = filter.getPredicate();
				schemaFilter = schemaFilter.replaceAll(" ",""); //$NON-NLS-1$ //$NON-NLS-2$
				if(schemaFilter.startsWith("IN(")) //$NON-NLS-1$
				{
					schemaFilter = schemaFilter.substring(3, schemaFilter.length() - 1); // skip "IN(" and ")"
					schemaFilter = schemaFilter.replaceAll(",",""); //$NON-NLS-1$ //$NON-NLS-2$
					schemaAry = this.parseINClause(schemaFilter);
				}
				if(schemaFilter.startsWith("LIKE")) //$NON-NLS-1$
				{
					pattern = this.parseLikeClause(schemaFilter); // Get '%d' or 'd%' or '%d%'
				}
			}
			DatabaseMetaData metaData = this.connection.getMetaData();
			ResultSet r = metaData.getSchemas();
			while (r.next()){
				final String schemaName = r.getString(1);
				if(schemaAry != null)
				{
					boolean found = false;
					for(int i = 0; i < schemaAry.length; i++)
					{
						if(schemaName.equals(schemaAry[i])) 
						{
							found = true;
							break; // for
						}
					}
					if(!found) continue; // while
				}
				if(pattern != null)
				{
					/* Check 'd%' begin with */
					if(pattern.indexOf("%") == 0 && pattern.endsWith("%")) //$NON-NLS-1$ //$NON-NLS-2$
					{
						if(schemaName.indexOf(pattern.substring(1, pattern.length() - 1)) != -1){}
						else continue;
					}
					else if(pattern.indexOf("%") == 0) // '%d' //$NON-NLS-1$
					{
						if(schemaName.endsWith(pattern.substring(1))){}
						else continue;
					}
					else // 'd%'
					{
						if(schemaName.startsWith(pattern.substring(0, pattern.length() - 1))){}
						else continue;
					}
				}
				Schema schema = new JDBCSchema();
				schema.setName(schemaName);
				schemaList.add(schema);
			}
			this.schemasLoaded = true;
			r.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		this.eSetDeliver(deliver);
	}
/* This method can be moved to util package so that all others metadata
 * processing would have access to it
 */
	protected String[] parseINClause(String toParse)
	{
        StringTokenizer tokenizer = new StringTokenizer(toParse, "'"); //$NON-NLS-1$
        Vector list = new Vector();
        String result = null;
        if(tokenizer.countTokens () >= 1) {
        	while (tokenizer.hasMoreTokens()) {
            	list.add(tokenizer.nextToken());
            }
        }
        String[] retStrList = null;
        if (list.size() > 0)
        {
        	retStrList = new String[list.size()];
        	for(int i = 0; i < list.size(); i++){
        		retStrList[i] = (String)list.get(i);
        	}
        }
        return retStrList;
		
	}
	
	/* This method can be moved to util package so that all others metadata
	 * processing would have access to it
	 */
	protected String parseLikeClause(String toParse)
	{
        String retString = toParse.substring(toParse.indexOf("'") + 1, toParse.length() - 1); // Strip off begin LIKE' and end ' //$NON-NLS-1$
        return retString;
	}
	private Connection connection;
	private boolean schemasLoaded = false;
	
}
