/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.server.geronimo.ui.internal;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.server.geronimo.core.internal.model.ResourceRef;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DPEditorResRef {
	private static final String TARGET = "target";
	private static final String LINK = "link";
	private static final String NAME = "name";

	protected FormToolkit toolkit;
	protected Table resRefTable;
	protected DPEditor dpEditor;
	
	public DPEditorResRef(DPEditor editor, FormToolkit tk) {
		dpEditor=editor;
		toolkit=tk;
	}

	public void createControls(Composite columnComp) {
		Section section = toolkit.createSection(columnComp,
				ExpandableComposite.TWISTIE | ExpandableComposite.EXPANDED
						| ExpandableComposite.TITLE_BAR | Section.DESCRIPTION
						| ExpandableComposite.FOCUS_TITLE);
		section.setText(Messages.editorResourceRefTitle);
		section.setDescription(Messages.editorResourceRefDescription);
		section.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));

		Composite composite = toolkit.createComposite(section);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 5;
		layout.marginWidth = 10;
		layout.verticalSpacing = 5;
		layout.horizontalSpacing = 15;
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
		section.setClient(composite);

		// ------------------------------------------------------
		resRefTable = new Table(composite, SWT.BORDER | SWT.FULL_SELECTION
				| SWT.V_SCROLL | SWT.H_SCROLL | SWT.SINGLE);
		resRefTable.setHeaderVisible(true);

		GridData data = new GridData(SWT.FILL, SWT.FILL, false, false);
		data.heightHint = 60;
		data.widthHint = 400;
		resRefTable.setLayoutData(data);

		TableLayout tableLayout = new TableLayout();
		resRefTable.setLayout(tableLayout);

		tableLayout.addColumnData(new ColumnWeightData(35));
		TableColumn refNameCol = new TableColumn(resRefTable, SWT.NONE);
		refNameCol.setText(Messages.editorResRefNameTitle);

		tableLayout.addColumnData(new ColumnWeightData(35));
		TableColumn resLinkCol = new TableColumn(resRefTable, SWT.NONE);
		resLinkCol.setText(Messages.editorResRefLinkTitle);

		tableLayout.addColumnData(new ColumnWeightData(30));
		TableColumn targetNameCol = new TableColumn(resRefTable, SWT.NONE);
		targetNameCol.setText(Messages.editorResRefTargetNameTitle);

		ResourceRef[] resourceRefs = dpEditor.getPlan().getResourceRefs();
		for (int i = 0; i < resourceRefs.length; i++) {
			TableItem item = new TableItem(resRefTable, SWT.NONE);
			String[] tableTextData=getTableText(resourceRefs[i]);
			item.setText(tableTextData);
			item.setData(resourceRefs[i]);
		}
		
		TableViewer resRefTableViewer = new TableViewer(resRefTable);
		TextCellEditor cellEditor = new TextCellEditor(resRefTable);
		resRefTableViewer.setCellEditors(new CellEditor[] { cellEditor,
				cellEditor, cellEditor });
		resRefTableViewer
				.setColumnProperties(new String[] { NAME, LINK, TARGET });
		ICellModifier cellModifier = new ICellModifier() {
			public Object getValue(Object element, String property) {
				ResourceRef resRef = (ResourceRef) element;
				String value = "";
				if (NAME.equals(property))
					value = resRef.getRefName();
				else if (LINK.equals(property))
					value = resRef.getResourceLink();
				else if (TARGET.equals(property))
					value = resRef.getTargetName();
				return value;
			}

			public boolean canModify(Object element, String property) {
				return true;
			}

			public void modify(Object element, String property, Object value) {
				TableItem item=null;
				if (element instanceof TableItem) {
					item = (TableItem)element;
					element = item.getData();
				}
				ResourceRef resRef = (ResourceRef) element;
				if (NAME.equals(property))
					resRef.setRefName((String) value);
				else if (LINK.equals(property))
					resRef.setResourceLink((String) value);
				else if (TARGET.equals(property))
					resRef.setTargetName((String) value);

				if(item!=null)
				{
					String[] tableTextData = getTableText(resRef);
					item.setText(tableTextData);
				}
				dpEditor.setDirty(true);
			}
		};
		resRefTableViewer.setCellModifier(cellModifier);

		// ---------- Buttons ----------
		Composite buttonComp = new Composite(composite, SWT.NONE);
		layout = new GridLayout();
		layout.horizontalSpacing = 2;
		layout.verticalSpacing = 2;
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.numColumns = 1;
		buttonComp.setLayout(layout);
		buttonComp.setBackground(toolkit.getColors().getBackground());
		buttonComp.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));

		Button add = toolkit.createButton(buttonComp, Messages.add, SWT.NONE);
		add.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem item = new TableItem(resRefTable, SWT.NONE);
				String defaultRefName = "NewRef";
				String[] s = new String[] { defaultRefName, "", "" };
				ResourceRef resRef = ResourceRef.createResourceRef(dpEditor.getPlan(),
						defaultRefName, null, null);
				item.setText(s);
				item.setData(resRef);
				dpEditor.setDirty(true);
			}
		});
		add.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		
		Button del = toolkit.createButton(buttonComp, Messages.remove, SWT.NONE);
		del.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int[] selectedResRefIndices = resRefTable
						.getSelectionIndices();
				for (int i = 0; i < selectedResRefIndices.length; i++) {
					TableItem resRefItem = resRefTable
							.getItem(selectedResRefIndices[i]);
					ResourceRef resRef = (ResourceRef) (resRefItem
							.getData());
					resRefTable.remove(selectedResRefIndices[i]);
					dpEditor.getPlan().removeResourceRef(resRef);
					dpEditor.setDirty(true);
				}
			}
		});
		del.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	}

	protected String[] getTableText(ResourceRef ref) {
		String[] s = new String[] { ref.getRefName(),
				ref.getResourceLink(),
				ref.getTargetName() };
		return s;
	}	
}