/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorRegistry;

// TODO Fix up Common Sorter

/**
 * <p>
 * Provides generic, extensible sorting strategies for the Common Navigator.
 * </p>
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class CommonSorter extends ViewerSorter {

	private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();

	private NavigatorRegistry navigatorRegistry = null;
	private Comparator comparator = null;
	private NavigatorContentService contentService;


	/**
	 * 
	 */
	public CommonSorter(NavigatorContentService aContentService) {
		super();
		contentService = aContentService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ViewerSorter#category(java.lang.Object)
	 */
	public int category(Object anElement) {
		List descriptors = CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(anElement);
		if (descriptors.size() > 0)
			return ((NavigatorContentDescriptor) descriptors.get(0)).getPriority();
		return Priority.NORMAL_PRIORITY_VALUE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public int compare(Viewer viewer, Object lvalue, Object rvalue) {
		int rank = category(rvalue) - category(lvalue);
		if(rank == 0) { 
			IStructuredSelection selection = new StructuredSelection(new Object[] {lvalue, rvalue});
			NavigatorContentDescriptorInstance[] descriptorInstances = contentService.findRelevantContentDescriptorInstances(selection);
			if(descriptorInstances.length > 0)
				return descriptorInstances[0].getSorter().compare(lvalue, rvalue);
			return rank;
			
		}
		return rank;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ViewerSorter#sort(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object[])
	 */
	public void sort(Viewer viewer, Object[] elements) {
		Arrays.sort(elements, getComparator());
	}
	
	// M4 Remove this method [CommonNavigator]
	/**
	 * @deprecated To be removed in M4
	 * @return Returns the navigatorRegistry.
	 */
	protected NavigatorRegistry getNavigatorRegistry() {
		if (navigatorRegistry == null)
			navigatorRegistry = NavigatorPlugin.getDefault().getNavigatorRegistry();
		return navigatorRegistry;
	}

	protected Comparator getComparator() {
		if (comparator == null) {
			comparator = new Comparator() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
				 */
				public int compare(Object o1, Object o2) {
					return CommonSorter.this.compare(null, o1, o2);
				}
			};
		}
		return comparator;
	}


}