/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class DelegateCommonLabelProvider implements ICommonLabelProvider {

	private final ILabelProvider delegateLabelProvider;

	/**
	 * <p>
	 * Requires a non-null label provider as the parameter.
	 * </p>
	 */
	public DelegateCommonLabelProvider(ILabelProvider aLabelProvider) {
		super();
		delegateLabelProvider = aLabelProvider;
	}

	/**
	 * <p>
	 * No-op.
	 * </p>
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider#initialize(java.lang.String)
	 */
	public void initialize(String aViewerId) {
	}

	/**
	 * <p>
	 * Returns <b>null </b>, forcing the CommonNavigator to provide the default message.
	 * </p>
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider#getDescription(java.lang.Object)
	 */
	public String getDescription(Object element) {
		return null;
	}

	/**
	 * @param listener
	 */
	public void addListener(ILabelProviderListener listener) {
		delegateLabelProvider.addListener(listener);
	}

	/**
	 *  
	 */
	public void dispose() {
		delegateLabelProvider.dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		return delegateLabelProvider.equals(obj);
	}

	/**
	 * @param element
	 * @return
	 */
	public Image getImage(Object element) {
		return delegateLabelProvider.getImage(element);
	}

	/**
	 * @param element
	 * @return
	 */
	public String getText(Object element) {
		return delegateLabelProvider.getText(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return delegateLabelProvider.hashCode();
	}

	/**
	 * @param element
	 * @param property
	 * @return
	 */
	public boolean isLabelProperty(Object element, String property) {
		return delegateLabelProvider.isLabelProperty(element, property);
	}

	/**
	 * @param listener
	 */
	public void removeListener(ILabelProviderListener listener) {
		delegateLabelProvider.removeListener(listener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return delegateLabelProvider.toString();
	}
}