/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.core.editor;

import java.sql.*;
import java.util.*;


public interface ITableData {    
    
    public boolean isReadonly();
    
    public int getColumnCount();
    public String getColumnName(int col);   
    public int getColumnType(int col);
    public String getColumnHeader(int col);
    
    public Vector getRows();

    public IRowData insertRow();
    public void deleteRow(IRowData row);
    
    public boolean save() throws SQLException;
    public void revert();
    
    public void dispose();
}
