/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorRegistryReader;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class for the Navigator.
 */
public class NavigatorPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static NavigatorPlugin plugin;
	private NavigatorRegistry navigatorRegistry;
	public static String PLUGIN_ID = "org.eclipse.wst.common.navigator.views"; //$NON-NLS-1$

	/**
	 * Creates a new instance of the receiver
	 */
	public NavigatorPlugin() {
		super();
		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static NavigatorPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the navigator registry.
	 */
	public NavigatorRegistry getNavigatorRegistry() {
		if (navigatorRegistry == null) {
			navigatorRegistry = new NavigatorRegistry();
			NavigatorRegistryReader reader = new NavigatorRegistryReader();
			reader.readRegistry(Platform.getExtensionRegistry(), navigatorRegistry);
		}
		return navigatorRegistry;
	}

	/**
	 * Log the given status to the ISV log.
	 * 
	 * When to use this:
	 * 
	 * This should be used when a PluginException or a ExtensionException occur but for which an
	 * error dialog cannot be safely shown.
	 * 
	 * If you can show an ErrorDialog then do so, and do not call this method.
	 * 
	 * If you have a plugin exception or core exception in hand call log(String, IStatus)
	 * 
	 * This convenience method is for internal use by the Workbench only and must not be called
	 * outside the workbench.
	 * 
	 * This method is supported in the event the log allows plugin related information to be logged
	 * (1FTTJKV). This would be done by this method.
	 * 
	 * This method is internal to the workbench and must not be called by any plugins, or examples.
	 * 
	 * @param message
	 *            A high level UI message describing when the problem happened.
	 *  
	 */

	public static void log(String message) {
		getDefault().getLog().log(StatusUtil.newStatus(IStatus.ERROR, message, null));
		System.err.println(message);
		//1FTTJKV: ITPCORE:ALL - log(status) does not allow plugin information to be recorded
	}

	/**
	 * Logs errors.
	 */
	public static void log(String message, IStatus status) {
		if (message != null) {
			getDefault().getLog().log(StatusUtil.newStatus(IStatus.ERROR, message, null));
			System.err.println(message + "\nReason:"); //$NON-NLS-1$
		}
		getDefault().getLog().log(status);
		System.err.println(status.getMessage());
	}

	/**
	 * Initializes the navigator registry.
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
}