/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Sep 15, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.wst.common.navigator.internal.views.deferred;

import java.util.List;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;


/**
 * @author mdelder
 *  
 */
public class ProxyLabelProvider implements ICommonLabelProvider {

	private ProxyContentExtension proxyContentExtension;
	private List listeners;

	public ProxyLabelProvider(ProxyContentExtension proxyContentExtension) {
		this.proxyContentExtension = proxyContentExtension;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) {
		if (element instanceof ProxyRoot)
			return null;
		// TODO Update image for Proxy Root
		//			return
		// getProxyContentExtension().getExtensionSite().getNavigatorContentManager().getImage(((ProxyRoot)
		// element).id);
		else if (element instanceof ProxyPendingAdapter)
			return ((ProxyPendingAdapter) element).getIcon();
		return getDelegateLabelProvider().getImage(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
		if (element instanceof ProxyRoot)
			return ((ProxyRoot) element).name;
		return getDelegateLabelProvider().getText(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		if (shouldProxy())
			getListeners().add(listener);
		else
			getDelegateLabelProvider().addListener(listener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {

		if (!shouldProxy())
			getDelegateLabelProvider().dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object,
	 *      java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		if (shouldProxy())
			return false;
		return getDelegateLabelProvider().isLabelProperty(element, property);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		if (shouldProxy())
			getListeners().remove(listener);
		else
			getDelegateLabelProvider().removeListener(listener);
	}

	protected ILabelProvider getDelegateLabelProvider() {
		return getProxyContentExtension().getDelegateLabelProvider();
	}

	public boolean shouldProxy() {
		return getProxyContentExtension().isLabelProviderLoaded();
	}

	protected ProxyContentExtension getProxyContentExtension() {
		return proxyContentExtension;
	}

	protected List getListeners() {
		return listeners;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.extensions.ICommonLabelProvider#initialize(java.lang.String)
	 */
	public void initialize(String aViewerId) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.extensions.ICommonLabelProvider#getDescription(java.lang.Object)
	 */
	public String getDescription(Object anElement) {
		// TODO Auto-generated method stub
		return null;
	}
}