/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;
import org.eclipse.wst.rdb.data.internal.ui.*;
import org.eclipse.wst.rdb.internal.models.sql.tables.*;

public class EditTableDataAction implements IViewActionDelegate {

    protected Table table = null; 
    protected IViewPart view = null;

    public EditTableDataAction() {
        super();
    }

    public void run(IAction action) {
        
        if (table==null)
            return;

        IWorkbenchPage workbenchPage = view.getSite().getWorkbenchWindow().getActivePage();

        try {
            workbenchPage.openEditor(new TableDataEditorInput(table), "org.eclipse.wst.rdb.data.internal.ui.editor.tableDataEditor"); //$NON-NLS-1$
        } catch (PartInitException e) {
            DataUIPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);
        }

    }

    public void selectionChanged(IAction action, ISelection selection) {

        if (selection instanceof IStructuredSelection)
            if (  ((IStructuredSelection)selection).getFirstElement() instanceof Table )
                table = (Table) ((IStructuredSelection)selection).getFirstElement();
        
    }
    
    public void init(IViewPart view) {
        this.view = view;
    }

}
