/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.wst.rdb.data.internal.core.common.*;
import org.eclipse.wst.rdb.data.internal.core.editor.*;
import org.eclipse.wst.rdb.data.internal.ui.*;

public class TableDataLabelProvider implements ITableLabelProvider {

   
    public TableDataLabelProvider()
    {
    }
    
    public Image getColumnImage(Object element, int columnIndex) {        
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        
        if (!(element instanceof IRowData))
            return (columnIndex==0)?Messages.getString("TableDataLabelProvider.newRow"):""; //$NON-NLS-1$ //$NON-NLS-2$
    
        IRowData row = (IRowData)element;
    
        try {      
            Object o = row.getValue(columnIndex);
            String s = DataSerializer.serialize(o , row.getTable().getColumnType(columnIndex));
                
            return (s==null)?Messages.getString("TableDataLabelProvider.null"):s; //$NON-NLS-1$
        } catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(IStatus.ERROR, 0, ex.getMessage(), ex);
            return Messages.getString("TableDataLabelProvider.error"); //$NON-NLS-1$
        }
            
        
    }

    public void addListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub
        
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        // TODO Auto-generated method stub
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub
        
    }

    


}
