/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.util.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.wst.rdb.data.internal.core.editor.*;

public class TableDataTableCursor extends TableCursor implements ISelectionProvider {
    
	protected TableViewer tableViewer;
	
	protected ListenerList selectionChangedListeners = new ListenerList();
	
	public TableDataTableCursor(TableViewer tableViewer) {
		super(tableViewer.getTable(), SWT.NONE);
		this.tableViewer = tableViewer;
		setBackground(Display.getDefault().getSystemColor(SWT.COLOR_LIST_SELECTION));
		setForeground(Display.getDefault().getSystemColor(SWT.COLOR_LIST_SELECTION_TEXT));
		
		registerCellEditorsListener();
		registerSelectionListener();
		registerKeyListener();
		registerMouseListener();
		registerTraverseListener();
	}

    protected void registerTraverseListener() {
		addTraverseListener(new TraverseListener() {
            public void keyTraversed(TraverseEvent e) {
                handleTraverse(e);
                
            }
		});     
    }
	
    protected void registerMouseListener() {
		addMouseListener(new MouseListener() {
            public void mouseDoubleClick(MouseEvent e) {
            }
            public void mouseDown(MouseEvent e) {
                if (e.button==1)
                    edit();
            }
            public void mouseUp(MouseEvent e) {
            }
		});
    }

    protected void registerKeyListener() {
		addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent e) {
				if(e.character!='\0' && e.character!=SWT.CR && e.character!=SWT.LF &&
				        e.character!=SWT.BS && e.character!=SWT.DEL && e.character!=SWT.TAB &&
				        e.character!=SWT.ESC
				    && (e.stateMask==0 || e.stateMask==SWT.SHIFT)){
					
					edit();
					
					CellEditor editor = tableViewer.getCellEditors()[getColumn()];
					if (editor instanceof TextCellEditor) {
						editor.setValue(String.valueOf(e.character));
						((Text)editor.getControl()).setSelection(1);
					}

				}
			}
			public void keyReleased(KeyEvent e) {
			}
		});	
    }

    protected void registerSelectionListener() {
		addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
//			    tableViewer.getCellEditors()[getColumn()].deactivate();
//			    tableViewer.setSelection(new StructuredSelection(getRow()), true);
//			    tableViewer.getTable().setSelection(new TableItem[] {getRow()});
			    selectionChanged();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				edit();
			}
		});       
    }

    protected void registerCellEditorsListener()
	{
		ICellEditorListener editorListener = new ICellEditorListener() {
            public void applyEditorValue() {
        		setVisible(true);
        		redraw();
            }
            public void cancelEditor() {
                setVisible(true);
            }
            public void editorValueChanged(boolean oldValidState, boolean newValidState) { 
            }
		};
		
		
		CellEditor editors[] = tableViewer.getCellEditors();
		for (int i=0; i<editors.length; ++i)
		    if (editors[i]!=null)
		        editors[i].addListener(editorListener);
	}
	
	public void edit() {
	    if (((ITableData)tableViewer.getInput()).isReadonly())
	        return;
	    Object o = getRow().getData();
		((TableDataCellModifier)tableViewer.getCellModifier()).setCanModify(true);
		tableViewer.editElement(o, getColumn());
		((TableDataCellModifier)tableViewer.getCellModifier()).setCanModify(false);
		setVisible(false);
	}
	
	protected void handleTraverse(TraverseEvent event)
	{
	    int row = (getRow()==null) ? 0 : tableViewer.getTable().indexOf(getRow());
		int col = getColumn();
		
		switch (event.detail) {
		case SWT.TRAVERSE_TAB_PREVIOUS:		    
		    if (col!=0)
		        col--;
		    else { 
		        if (row!=0 ) {
			        col=tableViewer.getTable().getColumnCount()-1;
			        row--;
		        } else {
		            return;
		        }
		    }
		    setSelection(row, col);
			event.doit = false;
			return;
		case SWT.TRAVERSE_TAB_NEXT:
		    if (col!=tableViewer.getTable().getColumnCount()-1)
		        col++;
		    else {
		        if (row!=tableViewer.getTable().getItemCount()-1) {				            
		            col=0;
		            row++;
		        } else {
		            return;
		        }
		    }
		    setSelection(row, col);
		    event.doit = false;
		    return;
		}
		    
	}


    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        selectionChangedListeners.add(listener);        
    }

    public ISelection getSelection() {
        if (getRow()==null)
            return null;
        return new CellSelection(getRow().getData(), getColumn());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        selectionChangedListeners.remove(listener);        
    }

    public void setSelection(ISelection selection) {
        // TODO Auto-generated method stub
    }
	
	public void selectionChanged() {
		Object[] listeners = selectionChangedListeners.getListeners();
		for (int i = 0; i < listeners.length; ++i) {
			final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
			Platform.run(new SafeRunnable() {
				public void run() {
					l.selectionChanged(new SelectionChangedEvent(TableDataTableCursor.this, getSelection()));
				}
			});		
		}
	}
}