/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public class FilterDialog
extends Dialog {
    private Button limit;
    private Text limitText;
    private Button okButton;
    private Button errorButton;
    private Button warningButton;
    private Button infoButton;
    private Button showAllButton;
    private IMemento memento;

    public FilterDialog(Shell parentShell, IMemento memento) {
        super(parentShell);
        this.memento = memento;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createEventTypesGroup(container);
        this.createLimitSection(container);
        this.createSessionSection(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createEventTypesGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 275;
        group.setLayoutData((Object)gd);
        group.setText(PDERuntimeMessages.LogView_FilterDialog_eventTypes);
        this.infoButton = new Button((Composite)group, 32);
        this.infoButton.setText(PDERuntimeMessages.LogView_FilterDialog_information);
        this.infoButton.setSelection(this.memento.getString("info").equals("true"));
        this.warningButton = new Button((Composite)group, 32);
        this.warningButton.setText(PDERuntimeMessages.LogView_FilterDialog_warning);
        this.warningButton.setSelection(this.memento.getString("warning").equals("true"));
        this.errorButton = new Button((Composite)group, 32);
        this.errorButton.setText(PDERuntimeMessages.LogView_FilterDialog_error);
        this.errorButton.setSelection(this.memento.getString("error").equals("true"));
    }

    private void createLimitSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.limit = new Button(comp, 32);
        this.limit.setText(PDERuntimeMessages.LogView_FilterDialog_limitTo);
        this.limit.setSelection(this.memento.getString("useLimit").equals("true"));
        this.limit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterDialog.this.limitText.setEnabled(((Button)e.getSource()).getSelection());
            }
        });
        this.limitText = new Text(comp, 2048);
        this.limitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (FilterDialog.this.okButton == null) {
                        return;
                    }
                    Integer.parseInt(FilterDialog.this.limitText.getText());
                    FilterDialog.this.okButton.setEnabled(true);
                }
                catch (NumberFormatException numberFormatException) {
                    FilterDialog.this.okButton.setEnabled(false);
                }
            }
        });
        this.limitText.setLayoutData((Object)new GridData(768));
        this.limitText.setText(this.memento.getString("limit"));
        this.limitText.setEnabled(this.limit.getSelection());
    }

    private void createSessionSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 0);
        label.setText(PDERuntimeMessages.LogView_FilterDialog_eventsLogged);
        this.showAllButton = new Button(container, 16);
        this.showAllButton.setText(PDERuntimeMessages.LogView_FilterDialog_allSessions);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.showAllButton.setLayoutData((Object)gd);
        Button button = new Button(container, 16);
        button.setText(PDERuntimeMessages.LogView_FilterDialog_recentSession);
        gd = new GridData();
        gd.horizontalIndent = 20;
        button.setLayoutData((Object)gd);
        if (this.memento.getString("allSessions").equals("true")) {
            this.showAllButton.setSelection(true);
        } else {
            button.setSelection(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.memento.putString("info", this.infoButton.getSelection() ? "true" : "false");
        this.memento.putString("warning", this.warningButton.getSelection() ? "true" : "false");
        this.memento.putString("error", this.errorButton.getSelection() ? "true" : "false");
        this.memento.putString("limit", this.limitText.getText());
        this.memento.putString("useLimit", this.limit.getSelection() ? "true" : "false");
        this.memento.putString("allSessions", this.showAllButton.getSelection() ? "true" : "false");
        super.okPressed();
    }
}

