/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.Vector;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.registry.RegistryPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PrerequisitePropertySource
extends RegistryPropertySource {
    private IPluginPrerequisite prereq;
    public static final String P_ID = "id";
    public static final String P_VERSION = "version";
    public static final String P_EXPORTED = "exported";
    public static final String P_MATCH = "match";
    public static final String P_OPTIONAL = "optional";

    public PrerequisitePropertySource(IPluginPrerequisite prereq) {
        this.prereq = prereq;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Vector<PropertyDescriptor> result = new Vector<PropertyDescriptor>();
        result.addElement(new PropertyDescriptor((Object)P_EXPORTED, PDERuntimeMessages.RegistryView_prerequisitePR_exported));
        result.addElement(new PropertyDescriptor((Object)P_ID, PDERuntimeMessages.RegistryView_prerequisitePR_id));
        result.addElement(new PropertyDescriptor((Object)P_VERSION, PDERuntimeMessages.RegistryView_prerequisitePR_version));
        result.addElement(new PropertyDescriptor((Object)P_MATCH, PDERuntimeMessages.RegistryView_prerequisitePR_match));
        result.addElement(new PropertyDescriptor((Object)P_OPTIONAL, PDERuntimeMessages.RegistryView_prerequisitePR_optional));
        return this.toDescriptorArray(result);
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_ID)) {
            return this.prereq.getUniqueIdentifier();
        }
        if (name.equals(P_EXPORTED)) {
            return this.prereq.isExported() ? "true" : "false";
        }
        if (name.equals(P_VERSION)) {
            PluginVersionIdentifier version = this.prereq.getVersionIdentifier();
            return version != null ? version.toString() : "";
        }
        if (name.equals(P_OPTIONAL)) {
            return this.prereq.isOptional() ? "true" : "false";
        }
        if (name.equals(P_MATCH)) {
            if (this.prereq.isMatchedAsCompatible()) {
                return PDERuntimeMessages.RegistryView_prerequisitePR_matchedCompatible;
            }
            if (this.prereq.isMatchedAsEquivalent()) {
                return PDERuntimeMessages.RegistryView_prerequisitePR_matchedEquivalent;
            }
            if (this.prereq.isMatchedAsExact()) {
                return PDERuntimeMessages.RegistryView_prerequisitePR_matchedExact;
            }
            if (this.prereq.isMatchedAsGreaterOrEqual()) {
                return PDERuntimeMessages.RegistryView_prerequisitePR_matchedGreaterOrEqual;
            }
            if (this.prereq.isMatchedAsPerfect()) {
                return PDERuntimeMessages.RegistryView_prerequisitePR_matchedPerfect;
            }
        }
        return "";
    }
}

