/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.section;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.util.XMLQuickScan;
import org.w3c.dom.Element;

public class ImportSection
extends AbstractSection {
    protected Text namespaceText;
    protected Text prefixText;
    protected Text locationText;
    private String oldPrefixValue;
    Button button;
    IEditorPart editorPart;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.namespaceText = this.getWidgetFactory().createText(composite, "");
        this.namespaceText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.namespaceText.setLayoutData((Object)data);
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(composite, WSDLEditorPlugin.getWSDLString("_UI_LABEL_NAMESPACE"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.namespaceText, -5);
        data.top = new FormAttachment((Control)this.namespaceText, 0, 0x1000000);
        namespaceLabel.setLayoutData((Object)data);
        this.prefixText = this.getWidgetFactory().createText(composite, "");
        this.prefixText.addListener(24, (Listener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.namespaceText, 4);
        this.prefixText.setLayoutData((Object)data);
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(composite, WSDLEditorPlugin.getWSDLString("_UI_LABEL_PREFIX"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.prefixText, -5);
        data.top = new FormAttachment((Control)this.prefixText, 0, 0x1000000);
        prefixLabel.setLayoutData((Object)data);
        this.locationText = this.getWidgetFactory().createText(composite, "");
        this.locationText.setEditable(false);
        CLabel locationLabel = this.getWidgetFactory().createCLabel(composite, WSDLEditorPlugin.getWSDLString("_UI_LABEL_LOCATION"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.locationText, -5);
        data.top = new FormAttachment((Control)this.locationText, 0, 0x1000000);
        locationLabel.setLayoutData((Object)data);
        this.button = this.getWidgetFactory().createButton(composite, "", 8);
        this.button.setImage(WSDLEditorPlugin.getInstance().getImage("icons/browsebutton.gif"));
        this.button.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(100, -this.rightMarginSpace + 2);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.locationText, 0, 0x1000000);
        this.button.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment((Control)this.button, 0);
        data.top = new FormAttachment((Control)this.prefixText, 4);
        this.locationText.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        WSDLElement obj = this.getElement();
        boolean refreshPrefixText = true;
        boolean refreshLocationText = true;
        boolean refreshNamespaceText = true;
        if (this.prefixText.isFocusControl()) {
            refreshPrefixText = false;
        }
        if (this.locationText.isFocusControl()) {
            refreshLocationText = false;
        }
        if (this.namespaceText.isFocusControl()) {
            refreshNamespaceText = false;
        }
        if (refreshPrefixText) {
            this.prefixText.setText("");
        }
        if (refreshLocationText) {
            this.locationText.setText("");
        }
        if (refreshNamespaceText) {
            this.namespaceText.setText("");
        }
        if (obj instanceof Import) {
            Element element = ((Import)obj).getElement();
            if (refreshLocationText) {
                String locationValue = element.getAttribute("location");
                this.locationText.setText(locationValue != null ? locationValue : "");
            }
            String namespaceValue = element.getAttribute("namespace");
            if (refreshNamespaceText) {
                this.namespaceText.setText(namespaceValue != null ? namespaceValue : "");
            }
            if (refreshPrefixText) {
                String prefix = ((Import)obj).getEnclosingDefinition().getPrefix(namespaceValue);
                this.prefixText.setText(prefix != null ? prefix : "");
            }
        }
        this.oldPrefixValue = this.prefixText.getText();
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.prefixText && this.locationText.getText().length() > 0 && this.namespaceText.getText().length() > 0) {
            WSDLElement input = this.getElement();
            Import importObj = (Import)input;
            WSDLEditorUtil.getInstance().getElementForObject(importObj);
            Map namespacesMap = importObj.getEnclosingDefinition().getNamespaces();
            if (!namespacesMap.containsKey(this.prefixText.getText())) {
                Element definitionElement = importObj.getEnclosingDefinition().getElement();
                definitionElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                definitionElement.setAttribute("xmlns:" + this.prefixText.getText(), this.namespaceText.getText());
                this.oldPrefixValue = this.prefixText.getText();
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            WSDLElement input = this.getElement();
            ((EObject)input).eResource().getResourceSet();
            WSDLEditor editor = (WSDLEditor)this.editorPart;
            IFile currentWSDLFile = ((IFileEditorInput)editor.getEditorInput()).getFile();
            SelectSingleFileDialog dialog = new SelectSingleFileDialog(WSDLEditorPlugin.getShell(), null, true);
            String[] filters = new String[]{"xsd", "wsdl"};
            IFile[] excludedFiles = new IFile[]{currentWSDLFile};
            dialog.addFilterExtensions(filters, excludedFiles);
            dialog.create();
            dialog.getShell().setText(WSDLEditorPlugin.getWSDLString("_UI_TITLE_SELECT"));
            dialog.setTitle(WSDLEditorPlugin.getWSDLString("_UI_TITLE_SELECT_FILE"));
            dialog.setMessage(WSDLEditorPlugin.getWSDLString("_UI_DESCRIPTION_SELECT_WSDL_OR_XSD"));
            int rc = dialog.open();
            if (rc == 0) {
                IFile selectedFile = dialog.getFile();
                String location = ComponentReferenceUtil.computeRelativeURI(selectedFile, currentWSDLFile, true);
                Import importObj = (Import)input;
                Element importElement = WSDLEditorUtil.getInstance().getElementForObject(importObj);
                Definition definition = importObj.getEnclosingDefinition();
                Element definitionElement = WSDLEditorUtil.getInstance().getElementForObject(definition);
                String importTargetNamespace = "";
                String prefix = this.prefixText.getText();
                String uniquePrefix = "";
                URI uri = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString());
                importTargetNamespace = XMLQuickScan.getTargetNamespaceURIForSchema(uri.toString());
                uniquePrefix = prefix.trim().equals("") ? this.getUniquePrefix(definition, uri.fileExtension()) : prefix;
                if (importTargetNamespace == null || importTargetNamespace != null && importTargetNamespace.trim().length() == 0) {
                    return;
                }
                importElement.setAttribute("location", location);
                importElement.setAttribute("namespace", importTargetNamespace);
                definitionElement.setAttribute("xmlns:" + uniquePrefix, importTargetNamespace);
                this.namespaceText.setText(importTargetNamespace);
                this.locationText.setText(location);
                this.prefixText.setText(uniquePrefix);
            }
            this.refresh();
        }
    }

    private String getUniquePrefix(Definition definition, String initPrefix) {
        String uniquePrefix;
        Map map = definition.getNamespaces();
        if (definition.getNamespace(initPrefix) == null) {
            uniquePrefix = initPrefix;
        } else {
            String tempPrefix = initPrefix;
            int i = 1;
            while (map.containsKey(String.valueOf(tempPrefix) + i)) {
                ++i;
            }
            uniquePrefix = String.valueOf(tempPrefix) + i;
        }
        return uniquePrefix;
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }
}

