/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.section;

import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.graph.model.WSDLGraphModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.properties.section.WSDLTypeMapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;

public class WSDLLabelProvider
extends LabelProvider {
    protected ModelAdapterFactory adapterFactory = new WSDLModelAdapterFactory();
    private WSDLTypeMapper typeMapper = new WSDLTypeMapper();
    protected WSDLEditorExtension[] labelProviderExtensions;
    protected LabelProvider[] labelProviders;
    IEditorPart editorPart = WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();

    public WSDLLabelProvider() {
        WSDLEditorExtensionRegistry registry = WSDLEditorPlugin.getInstance().getWSDLEditorExtensionRegistry();
        this.labelProviderExtensions = registry.getRegisteredExtensions(2);
        this.labelProviders = new LabelProvider[this.labelProviderExtensions.length];
        int i = 0;
        while (i < this.labelProviderExtensions.length) {
            this.labelProviders[i] = (LabelProvider)this.labelProviderExtensions[i].createExtensionObject(2, (WSDLEditor)this.editorPart);
            ++i;
        }
    }

    public Image getImage(Object object) {
        if (object == null || object.equals(StructuredSelection.EMPTY)) {
            return null;
        }
        Image result = null;
        if (object instanceof StructuredSelection) {
            Object selected = ((StructuredSelection)object).getFirstElement();
            selected = this.typeMapper.remapObject(selected);
            int i = 0;
            while (i < this.labelProviders.length) {
                result = this.labelProviders[i].getImage(selected);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public String getText(Object object) {
        if (object == null || object.equals(StructuredSelection.EMPTY)) {
            return "No items selected";
        }
        String result = null;
        Object selected = null;
        if (object instanceof StructuredSelection) {
            selected = ((StructuredSelection)object).getFirstElement();
            if ((selected = this.typeMapper.remapObject(selected)) instanceof WSDLElement) {
                if (((WSDLElement)selected).getElement() == null) {
                    return "";
                }
                boolean isReadOnly = false;
                ModelAdapter adapter = WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory().getAdapter(selected);
                if (adapter != null) {
                    isReadOnly = Boolean.TRUE.equals(adapter.getProperty(selected, "isReadOnly"));
                }
                result = isReadOnly ? String.valueOf(((WSDLElement)selected).getElement().getLocalName()) + " (" + WSDLEditorPlugin.getWSDLString("_UI_LABEL_READ_ONLY") + ")" : ((WSDLElement)selected).getElement().getLocalName();
                return result;
            }
            if (selected instanceof XSDConcreteComponent) {
                Element element = ((XSDConcreteComponent)selected).getElement();
                if (element != null) {
                    if (element instanceof IDOMNode) {
                        return ((XSDConcreteComponent)selected).getElement().getLocalName();
                    }
                    return String.valueOf(((XSDConcreteComponent)selected).getElement().getLocalName()) + " (" + WSDLEditorPlugin.getWSDLString("_UI_LABEL_READ_ONLY") + ")";
                }
                return "(" + WSDLEditorPlugin.getWSDLString("_UI_LABEL_READ_ONLY") + ")";
            }
            int i = 0;
            while (i < this.labelProviders.length) {
                result = this.labelProviders[i].getText(selected);
                if (result == null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            boolean cfr_ignored_0 = object instanceof TextSelection;
        }
        return result;
    }

    private Object getObject(Object objects, boolean[] multiple) {
        Assert.isNotNull((Object)objects);
        Object object = null;
        return object;
    }
}

