/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormAction;
import org.eclipse.wst.ws.internal.explorer.platform.actions.ImportToFileSystemAction;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.wsil.AddWSDLToWSILCommand;

public abstract class ImportToWorkbenchAction
extends FormAction {
    private IWorkspaceRoot iWorkspaceRoot_ = ResourcesPlugin.getWorkspace().getRoot();
    private IProject iProject_;
    private IResource targetFileResource_;

    public ImportToWorkbenchAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String importToWSIL;
        this.getSelectedFormTool();
        MessageQueue msgQueue = this.controller_.getCurrentPerspective().getMessageQueue();
        boolean inputsValid = true;
        String workbenchProjectName = parser.getParameter("workbenchProjectName");
        if (workbenchProjectName == null || workbenchProjectName.length() <= 0) {
            msgQueue.addMessage(this.controller_.getMessage("MSG_ERROR_INVALID_WORKBENCH_PROJECT"));
            inputsValid = false;
        } else {
            this.iProject_ = this.iWorkspaceRoot_.getProject(workbenchProjectName);
            this.propertyTable_.put("workbenchProjectName", workbenchProjectName);
        }
        String importFile = parser.getParameter("importWSDL");
        if (importFile != null) {
            this.propertyTable_.put("importWSDL", "importWSDL");
            String importedFileName = parser.getParameter("importedFileName");
            if (importedFileName == null || importedFileName.length() <= 0) {
                msgQueue.addMessage(this.controller_.getMessage("MSG_ERROR_INVALID_FILE_NAME"));
                inputsValid = false;
            } else {
                this.propertyTable_.put("importedFileName", importedFileName);
            }
        }
        if ((importToWSIL = parser.getParameter("importToWSIL")) != null) {
            this.propertyTable_.put("importToWSIL", "importToWSIL");
            this.propertyTable_.put("importedWsdlUrl", parser.getParameter("importedWsdlUrl"));
            String wsilFileName = parser.getParameter("WSILFileName");
            if (wsilFileName == null || wsilFileName.length() <= 0) {
                msgQueue.addMessage(this.controller_.getMessage("MSG_ERROR_INVALID_WSIL_FILE_NAME"));
                inputsValid = false;
            } else {
                this.propertyTable_.put("WSILFileName", wsilFileName);
            }
        }
        if (importFile == null && importToWSIL == null) {
            msgQueue.addMessage(this.controller_.getMessage("MSG_ERROR_NO_IMPORT_OPTION_SELECTED"));
            inputsValid = false;
        }
        return inputsValid;
    }

    private OutputStream getOutputStream(String defaultFileName) throws FileNotFoundException {
        File file = new File(String.valueOf(this.controller_.getServletEngineStateLocation()) + defaultFileName);
        FileOutputStream fos = new FileOutputStream(file);
        return fos;
    }

    private boolean importTempFileToWebProject(String defaultFileName) throws FileNotFoundException, CoreException {
        if (this.targetFileResource_ != null && this.targetFileResource_.getType() == 1) {
            this.targetFileResource_.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        String importedFileName = (String)this.propertyTable_.get("importedFileName");
        File file = new File(String.valueOf(this.controller_.getServletEngineStateLocation()) + defaultFileName);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        IFile iFile = this.iProject_.getFile("/" + importedFileName);
        iFile.create((InputStream)bis, true, (IProgressMonitor)new NullProgressMonitor());
        file.delete();
        return true;
    }

    public boolean fileExists() {
        String importedFileName = (String)this.propertyTable_.get("importedFileName");
        if (importedFileName != null) {
            this.targetFileResource_ = this.iProject_.findMember(importedFileName);
            return this.targetFileResource_ != null && this.targetFileResource_.getType() == 1;
        }
        return false;
    }

    public boolean isTargetFileResourceReadOnly() {
        return this.targetFileResource_.getResourceAttributes().isReadOnly();
    }

    public boolean isCheckoutFilesEnabled() {
        return true;
    }

    public String getWebServicePluginFileMessage(String messageId) {
        String importedFileName = (String)this.propertyTable_.get("importedFileName");
        return this.controller_.getMessage(messageId, new String[]{this.iProject_.getFullPath().toString(), importedFileName});
    }

    public boolean isOverwriteFilesEnabled() {
        return true;
    }

    public boolean validateEdit() {
        IFile[] files = new IFile[]{(IFile)this.targetFileResource_};
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, null);
        MessageQueue messageQueue = this.controller_.getCurrentPerspective().getMessageQueue();
        messageQueue.addMessage(status.getMessage());
        return status.isOK();
    }

    public boolean run() {
        MessageQueue msgQueue = this.controller_.getCurrentPerspective().getMessageQueue();
        if (this.propertyTable_.get("importWSDL") != null) {
            try {
                ImportToFileSystemAction action = this.newImportToFileSystemAction();
                action.run();
                String defaultFileName = action.getDefaultFileName();
                if (!action.write(this.getOutputStream(defaultFileName))) {
                    msgQueue.addMessage(this.controller_.getMessage("MSG_ERROR_WRITING_TEMP_FILE_TO_FS"));
                    return false;
                }
                this.importTempFileToWebProject(defaultFileName);
                String importedFileName = (String)this.propertyTable_.get("importedFileName");
                msgQueue.addMessage(this.controller_.getMessage("MSG_INFO_IMPORT_TO_WORKBENCH_SUCCESSFUL", importedFileName));
            }
            catch (FileNotFoundException fnfe) {
                msgQueue.addMessage(fnfe.getMessage());
                return false;
            }
            catch (CoreException ce) {
                msgQueue.addMessage(ce.getMessage());
                return false;
            }
        }
        if (this.propertyTable_.get("importToWSIL") != null) {
            String projectName = (String)this.propertyTable_.get("workbenchProjectName");
            String importedWSILFileName = (String)this.propertyTable_.get("WSILFileName");
            String wsdlURL = (String)this.propertyTable_.get("importedWsdlUrl");
            StringBuffer wsilPlatformURL = new StringBuffer("platform:/resource/");
            wsilPlatformURL.append(projectName);
            wsilPlatformURL.append('/');
            wsilPlatformURL.append(importedWSILFileName);
            AddWSDLToWSILCommand command = new AddWSDLToWSILCommand();
            String[] args = new String[]{"-wsil", wsilPlatformURL.toString(), "-wsdl", wsdlURL, "-resolvewsdl"};
            command.setArguments(args);
            command.execute((Environment)new EclipseEnvironment(null, null, null, null));
            msgQueue.addMessage(this.controller_.getMessage("MSG_INFO_IMPORT_SERVICE_REF_TO_WSIL_SUCCESSFUL", importedWSILFileName));
        }
        return true;
    }

    public abstract String getStatusContentVar();

    public abstract String getStatusContentPage();

    public abstract ImportToFileSystemAction newImportToFileSystemAction();
}

